<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\TaskTimeEntry;
use App\Models\Attendance;
use App\Models\User;

class ReportController extends Controller
{
    public function dailyTasks(Request $request)
    {
        $date = $request->query('date', now()->toDateString());
        $user_id = $request->query('user_id', null);

        $query = TaskTimeEntry::with('task','user')->where('date', $date);
        if($user_id) $query->where('user_id', $user_id);
        $entries = $query->orderBy('start_time')->get();

        $attendances = Attendance::with('user')->where('date',$date)->get()->keyBy('user_id');

        return view('reports', compact('entries','attendances','date'));
    }

    public function exportCsv(Request $request)
    {
        $date = $request->query('date', now()->toDateString());
        $entries = TaskTimeEntry::with('task','user')->where('date',$date)->orderBy('user_id')->get();

        $csv = [];
        $csv[] = ['User','Task','Start Time','End Time','Duration (mins)','Note'];
        foreach($entries as $e) {
            $csv[] = [
                $e->user->name ?? 'N/A',
                $e->task->title ?? 'N/A',
                $e->start_time,
                $e->end_time,
                $e->duration_minutes,
                str_replace(["\r","\n"],' ',$e->note)
            ];
        }
        $filename = 'daily_tasks_'.$date.'.csv';
        $handle = fopen('php://memory','w+');
        foreach($csv as $row) fputcsv($handle, $row);
        fseek($handle, 0);
        $content = stream_get_contents($handle);
        fclose($handle);
        return response($content, 200, [
            'Content-Type'=>'text/csv',
            'Content-Disposition'=>'attachment; filename='.$filename
        ]);
    }
}
