<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;
    protected $fillable = ['name','email','password','role','timezone','status'];

    protected $hidden = ['password'];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'status' => 'boolean',
    ];

    public function attendances() {
        return $this->hasMany(Attendance::class);
    }
    public function tasks() {
        return $this->hasMany(Task::class, 'assigned_to');
    }
    public function timeEntries() {
        return $this->hasMany(TaskTimeEntry::class);
    }
}
