@extends('layouts.app')
@section('content')
<div class="row justify-content-center">
  <div class="col-md-6">
    <div class="card shadow-sm">
      <div class="card-body">
        <h4 class="card-title mb-3">Login</h4>
        <form method="POST" action="/login">@csrf
          <div class="mb-3">
            <label class="form-label">Email</label>
            <input name="email" value="{{ old('email') }}" class="form-control" required>
            @error('email')<div class="text-danger small">{{ $message }}</div>@enderror
          </div>
          <div class="mb-3">
            <label class="form-label">Password</label>
            <input name="password" type="password" class="form-control" required>
            @error('password')<div class="text-danger small">{{ $message }}</div>@enderror
          </div>
          <button class="btn btn-primary">Login</button>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection
