<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Attendance App</title>
  <!-- Bootstrap 5 CDN -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" defer></script>
</head>
<body class="bg-light">
  <nav class="navbar navbar-expand-lg navbar-white bg-white shadow-sm">
    <div class="container">
      <a class="navbar-brand" href="/dashboard">Attendance App</a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMenu">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="navMenu">
        <ul class="navbar-nav me-auto mb-2 mb-lg-0">
          <li class="nav-item"><a class="nav-link" href="/attendance">Attendance</a></li>
          <li class="nav-item"><a class="nav-link" href="/tasks">Tasks</a></li>
          <li class="nav-item"><a class="nav-link" href="/reports/daily-tasks">Reports</a></li>
        </ul>
        <ul class="navbar-nav ms-auto">
          @guest
            <li class="nav-item"><a class="nav-link" href="/login">Login</a></li>
            <li class="nav-item"><a class="nav-link" href="/register">Register</a></li>
          @else
            <li class="nav-item"><a class="nav-link" href="#">{{ auth()->user()->name }}</a></li>
            <li class="nav-item">
              <form method="POST" action="/logout">@csrf<button class="btn btn-link nav-link" style="display:inline;padding:0">Logout</button></form>
            </li>
          @endguest
        </ul>
      </div>
    </div>
  </nav>

  <main class="container py-4">
    @if(session('success'))<div class="alert alert-success">{{ session('success') }}</div>@endif
    @if(session('error'))<div class="alert alert-danger">{{ session('error') }}</div>@endif
    @yield('content')
  </main>
</body>
</html>
