@extends('layouts.app')
@section('content')
<div class="bg-white p-4 rounded shadow">
  <h2 class="font-semibold">Daily Task Report — {{ $date }}</h2>
  <p><a href="/reports/daily-tasks/export?date={{ $date }}" class="text-blue-600">Export CSV</a></p>
  <table class="w-full mt-4">
    <thead><tr><th>User</th><th>Task</th><th>Start</th><th>End</th><th>Duration (mins)</th><th>Note</th></tr></thead>
    <tbody>
      @foreach($entries as $e)
      <tr>
        <td>{{ $e->user->name ?? 'N/A' }}</td>
        <td>{{ $e->task->title ?? 'N/A' }}</td>
        <td>{{ $e->start_time }}</td>
        <td>{{ $e->end_time ?? '-' }}</td>
        <td>{{ $e->duration_minutes ?? '-' }}</td>
        <td>{{ $e->note ?? '' }}</td>
      </tr>
      @endforeach
    </tbody>
  </table>
</div>
@endsection
