@extends('layouts.app')
@section('content')
<div class="bg-white p-4 rounded shadow">
  <h2 class="font-semibold">Tasks</h2>
  <form method="POST" action="/tasks" class="mb-4">@csrf
    <input name="title" placeholder="Task title" class="border p-2 mr-2" required>
    <button class="px-3 py-2 bg-blue-600 text-white rounded">Add</button>
  </form>

  <table class="w-full">
    <thead><tr><th>Title</th><th>Assignee</th><th>Status</th><th>Actions</th></tr></thead>
    <tbody>
      @foreach($tasks as $task)
      <tr>
        <td>{{ $task->title }}</td>
        <td>{{ $task->assignee->name ?? 'Unassigned' }}</td>
        <td>{{ $task->status }}</td>
        <td>
          <form method="POST" action="/tasks/{{ $task->id }}/start" style="display:inline">@csrf<button class="px-2 py-1 bg-green-500 text-white rounded">Start</button></form>
          <form method="POST" action="/tasks/{{ $task->id }}/stop" style="display:inline">@csrf<button class="px-2 py-1 bg-red-500 text-white rounded">Stop</button></form>
        </td>
      </tr>
      @endforeach
    </tbody>
  </table>
</div>
@endsection
