(function (wp) {
    const { __ } = wp.i18n;
    const { registerBlockType } = wp.blocks;
    const { InspectorControls } = wp.blockEditor || wp.editor;
    const { PanelBody, TextControl, SelectControl, ToggleControl, RangeControl } = wp.components;
    const ServerSideRender = wp.serverSideRender;

    registerBlockType('academic-notices/marquee', {
        title: __('Academic Notices Marquee', 'academic-notices-marquee'),
        icon: 'megaphone',
        category: 'widgets',
        supports: {
            align: ['wide', 'full']
        },
        attributes: {
            heading: {
                type: 'string',
                default: __('Notices', 'academic-notices-marquee')
            },
            type: {
                type: 'string',
                default: 'all'
            },
            limit: {
                type: 'number',
                default: 10
            },
            wrapperClass: {
                type: 'string',
                default: ''
            },
            showHeading: {
                type: 'boolean',
                default: true
            }
        },
        edit: function (props) {
            const { attributes, setAttributes } = props;

            return [
                wp.element.createElement(
                    InspectorControls,
                    {},
                    wp.element.createElement(
                        PanelBody,
                        { title: __('Settings', 'academic-notices-marquee'), initialOpen: true },
                        wp.element.createElement(TextControl, {
                            label: __('Heading', 'academic-notices-marquee'),
                            value: attributes.heading,
                            onChange: (value) => setAttributes({ heading: value })
                        }),
                        wp.element.createElement(SelectControl, {
                            label: __('Type', 'academic-notices-marquee'),
                            value: attributes.type,
                            options: [
                                { label: __('All', 'academic-notices-marquee'), value: 'all' },
                                { label: __('Notice', 'academic-notices-marquee'), value: 'notice' },
                                { label: __('Announcement', 'academic-notices-marquee'), value: 'announcement' },
                                { label: __('Upcoming', 'academic-notices-marquee'), value: 'upcoming' }
                            ],
                            onChange: (value) => setAttributes({ type: value })
                        }),
                        wp.element.createElement(RangeControl, {
                            label: __('Number of Items', 'academic-notices-marquee'),
                            value: attributes.limit,
                            min: 1,
                            max: 50,
                            onChange: (value) => setAttributes({ limit: value })
                        }),
                        wp.element.createElement(TextControl, {
                            label: __('Extra Wrapper Class', 'academic-notices-marquee'),
                            value: attributes.wrapperClass,
                            onChange: (value) => setAttributes({ wrapperClass: value })
                        }),
                        wp.element.createElement(ToggleControl, {
                            label: __('Show Heading', 'academic-notices-marquee'),
                            checked: attributes.showHeading,
                            onChange: (value) => setAttributes({ showHeading: value })
                        })
                    )
                ),
                wp.element.createElement(ServerSideRender, {
                    block: 'academic-notices/marquee',
                    attributes: attributes
                })
            ];
        },
        save: function () {
            // Dynamic block.
            return null;
        }
    });
})(window.wp);
