<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class ANM_Elementor_Notices_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'anm_notices_marquee';
    }

    public function get_title() {
        return __( 'Academic Notices Marquee', 'academic-notices-marquee' );
    }

    public function get_icon() {
        return 'eicon-notification';
    }

    public function get_categories() {
        return array( 'general' );
    }

    public function get_keywords() {
        return array( 'notice', 'marquee', 'announcement', 'school', 'college', 'university' );
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            array(
                'label' => __( 'Content', 'academic-notices-marquee' ),
            )
        );

        $this->add_control(
            'heading',
            array(
                'label'       => __( 'Heading', 'academic-notices-marquee' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => __( 'Notices', 'academic-notices-marquee' ),
                'placeholder' => __( 'Enter heading', 'academic-notices-marquee' ),
            )
        );

        $this->add_control(
            'type',
            array(
                'label'   => __( 'Type', 'academic-notices-marquee' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'all',
                'options' => array(
                    'all'          => __( 'All', 'academic-notices-marquee' ),
                    'notice'       => __( 'Notice', 'academic-notices-marquee' ),
                    'announcement' => __( 'Announcement', 'academic-notices-marquee' ),
                    'upcoming'     => __( 'Upcoming', 'academic-notices-marquee' ),
                ),
            )
        );

        $this->add_control(
            'limit',
            array(
                'label'   => __( 'Number of items', 'academic-notices-marquee' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 1,
                'max'     => 50,
                'default' => 10,
            )
        );

        $this->add_control(
            'show_heading',
            array(
                'label'        => __( 'Show heading', 'academic-notices-marquee' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'academic-notices-marquee' ),
                'label_off'    => __( 'No', 'academic-notices-marquee' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            )
        );

        $this->add_control(
            'wrapper_class',
            array(
                'label'       => __( 'Extra wrapper class', 'academic-notices-marquee' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'description' => __( 'Add additional CSS class for custom spacing/styling from your theme or builder.', 'academic-notices-marquee' ),
            )
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $heading       = isset( $settings['heading'] ) ? $settings['heading'] : '';
        $type          = isset( $settings['type'] ) ? $settings['type'] : 'all';
        $limit         = isset( $settings['limit'] ) ? intval( $settings['limit'] ) : 10;
        $wrapper_class = isset( $settings['wrapper_class'] ) ? $settings['wrapper_class'] : '';
        $show_heading  = ( isset( $settings['show_heading'] ) && 'yes' === $settings['show_heading'] ) ? 'yes' : 'no';

        $shortcode = sprintf(
            '[academic_notices heading="%s" type="%s" limit="%d" wrapper_class="%s" show_heading="%s"]',
            esc_attr( $heading ),
            esc_attr( $type ),
            $limit,
            esc_attr( $wrapper_class ),
            esc_attr( $show_heading )
        );

        echo do_shortcode( $shortcode ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }
}
