<div class="owt7-lms">
    <div class="owt7_library_about">
        <header class="header">
            <h1><?php esc_html_e("Library Management System", "library-management-system"); ?><sup>v<?php echo esc_html(LIBRARY_MANAGEMENT_SYSTEM_VERSION); ?></sup></h1>
        </header>

        <section class="introduction">
            <h2><?php esc_html_e("Introduction", "library-management-system"); ?></h2>
            <p>
                <?php esc_html_e("Welcome to the most advanced Library Management System (LMS) Plugin. Our LMS plugin is designed to streamline and enhance the management of libraries, offering an intuitive and powerful solution for organizing books, users, bookcases, transactions, etc. Whether you are running a small community library or a large institutional library, our plugin provides the tools you need to operate efficiently and effectively.", "library-management-system"); ?>
            </p>
        </section>

        <section class="features">
            <h2><?php esc_html_e("Features", "library-management-system"); ?></h2>
            <div class="features-container">

                <div class="feature">
                    <h3><?php esc_html_e("Book Management", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Manage your library's collection with ease. Add, edit, and categorize books effortlessly.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("User Management", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Keep track of your library members, their borrow history, and contact details.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Transaction Tracking", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Monitor all borrow and return transactions with detailed logs and reporting features.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Analytics and Reports", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Generate insightful reports to understand usage patterns and improve library services.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Customizable Settings", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Tailor the plugin settings to fit the specific needs of your library.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Secure and Reliable", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Ensure the safety and integrity of your library data with our secure system architecture.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Data Backup", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Safeguard your data by creating backups regularly with our plugin's data backup feature.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Late Fine System", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Implement a late fine system to manage overdue books and encourage timely returns.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Upload CSV and Save Data", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Import CSV data files to LMS. Just follow some pattern to prepare data and feed into system.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Multilanguage Support", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Use the plugin in multiple languages, making it accessible to a wider audience. More than 5 Languages it supports.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Book Listing with Filters", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Create a frontend page to list all books with filters, enhancing user browsing experience. It also opens single book page view. Plugin Shortcodes.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Book Listing with Pagination Links", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Easy to move here and there to see list of books by pagination links.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Check Book Availability", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Allow users to check the availability of books from the frontend page without login.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Bulk Data Operation", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Allow admin to do bulk operation for Delete, Move to Active Status, Inactive Status for any module like Bookcases, Sections, Categories, Books, etc", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Data Clone Function", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Allow admin to create a copy of existing data for any module like Bookcases, Sections, Categories, Books, etc", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Self Checkout / Return Book(s) by User", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Allow users to checkout any book by themselves. Additionally, they can return in the same way.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Book(s) Borrow List / Return List of User", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("A Page to frontend where user can check the complete history of book(s) borrowed and returned.", "library-management-system"); ?></p>
                </div>
                
                <div class="feature">
                    <h3><?php esc_html_e("Request to Borrow Book", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Allow users to request or booking to borrow a book. Admin processes the user's request.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Sync WordPress Users in LMS", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("LMS admin can sync WordPress Users by Role into LMS.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Multiple Librarian to Manage LMS", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("LMS can be managed by more than one librarian admin.", "library-management-system"); ?></p>
                </div>

                <div class="feature">
                    <h3><?php esc_html_e("Sell Library Books into WooCommerce Store", "library-management-system"); ?></h3>
                    <p><?php esc_html_e("Website owner can market your PDF eBooks with WooCommerce store.", "library-management-system"); ?></p>
                </div>
            </div>
        </section>

        <section class="cta">
            <h2><?php esc_html_e("Get Started with Our Basic LMS Pro Plugin", "library-management-system"); ?></h2>
            <p><?php esc_html_e("Experience the future of library management today. Download our LMS plugin and transform the way you manage your library.", "library-management-system"); ?></p>
            <a href="<?php echo esc_url(LIBRARY_BUY_PRO_VERSION_LINK); ?>" target="_blank" class="cta-btn"><?php esc_html_e("Buy Basic Premium Version", "library-management-system"); ?> <?php echo esc_html(LIBRARY_MANAGEMENT_SYSTEM_VERSION); ?></a>
        </section>
    </div>
</div>
