<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://onlinewebtutorblog.com/
 * @since      3.0
 *
 * @package    Library_Management_System
 * @subpackage Library_Management_System/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Library_Management_System
 * @subpackage Library_Management_System/public
 * @author     Online Web Tutor <onlinewebtutorhub@gmail.com>
 */
class Library_Management_System_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    3.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    3.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	private $table_activator;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    3.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

		require_once LIBRARY_MANAGEMENT_SYSTEM_PLUGIN_DIR_PATH . 'includes/class-library-management-system-activator.php';
        $this->table_activator = new Library_Management_System_Activator();
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 * @since    3.0
	 */
	public function owt7_library_enqueue_styles() {

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/library-management-system-public.css', array(), $this->version, 'all' );

		wp_enqueue_style( "owt7-lms-toastr-css", plugin_dir_url( __FILE__ ) . 'css/toastr.min.css', array(), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 * @since    3.0
	 */
	public function owt7_library_enqueue_scripts() {

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/library-management-system-public.js', array( 'jquery' ), $this->version, false );

		wp_enqueue_script( "owt7-lms-toastr", plugin_dir_url( __FILE__ ) . 'js/toastr.min.js', array( 'jquery' ), $this->version, false );

		wp_localize_script($this->plugin_name, "owt7_library", array(
			"ajaxurl" => admin_url("admin-ajax.php"),
			"ajax_nonce" => wp_create_nonce('owt7_library_actions'),
			"page_no" => 1
		));
	}

	// All books Shortcode Handler
	public function owt7_library_all_books_shortcode($template){

		global $wpdb;

		$book_id = isset( $_REQUEST['bid'] ) ? trim( $_REQUEST['bid'] ) : "";

		$book_id = base64_decode($book_id);

		if($book_id && intval($book_id) > 0){
			// Single book data
			$book = $wpdb->get_row(
				"SELECT book.*, (SELECT category.name FROM ".$this->table_activator->owt7_library_tbl_category()." as category WHERE category.id = book.category_id LIMIT 1) as category_name, (SELECT bkcase.name FROM ".$this->table_activator->owt7_library_tbl_bookcase()." as bkcase WHERE bkcase.id = book.bookcase_id LIMIT 1) as bookcase_name, (SELECT section.name FROM ".$this->table_activator->owt7_library_tbl_bookcase_sections()." as section WHERE section.id = book.bookcase_section_id LIMIT 1) as section_name from " . $this->table_activator->owt7_library_tbl_books(). " as book WHERE book.id = {$book_id}"
			);

			if(!empty($book)){
				return $this->owt7_library_include_template_file("owt7_library_single_book", compact("book_id", "book"));
			}else{
				return $this->owt7_library_include_template_file("errors/owt7_library_404_page");
			}
		}else{
			
			$books_per_page = 10;

			$current_page = isset($_GET['p_no']) ? (int)$_GET['p_no'] : OWT7_LMS_DEFAULT_PAGE_NUMBER;
			$offset = ($current_page - 1) * $books_per_page;

			// All categories
			$categories = $wpdb->get_results(
				"SELECT category.*, (SELECT count(*) FROM ".$this->table_activator->owt7_library_tbl_books()." as book WHERE book.category_id = category.id LIMIT 1) as total_books from " . $this->table_activator->owt7_library_tbl_category(). " as category WHERE status = 1"
			);

			// Get Total Pages
			$all_books = $wpdb->get_var("SELECT COUNT(*) FROM {$this->table_activator->owt7_library_tbl_books()} WHERE status = 1");

			// Books Per Page Query
			$books = $wpdb->get_results(
				"SELECT book.*, (SELECT category.name FROM ".$this->table_activator->owt7_library_tbl_category()." as category WHERE category.id = book.category_id LIMIT 1) as category_name, (SELECT bkcase.name FROM ".$this->table_activator->owt7_library_tbl_bookcase()." as bkcase WHERE bkcase.id = book.bookcase_id LIMIT 1) as bookcase_name, (SELECT section.name FROM ".$this->table_activator->owt7_library_tbl_bookcase_sections()." as section WHERE section.id = book.bookcase_section_id LIMIT 1) as section_name from " . $this->table_activator->owt7_library_tbl_books(). " as book WHERE status = 1 LIMIT {$books_per_page} OFFSET {$offset}"
			);

			// Calculate total pages
			$total_pages = ceil($all_books / $books_per_page);

			return $this->owt7_library_include_template_file("owt7_library_books", compact("books", "categories", "total_pages", "current_page"));
		}
	}

	// Helper function
	public function owt7_library_include_template_file($template, $lib_params = array()){

		ob_start();
		$params = $lib_params;
		include_once LIBRARY_MANAGEMENT_SYSTEM_PLUGIN_DIR_PATH . 'public/views/' . $template . ".php";
		$template = ob_get_contents();
		ob_end_clean();

		return $template;
	}
}