<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Session;

class SocialiteController extends Controller
{
    public function loginSocial(Request $request, string $provider): RedirectResponse
    {
        $this->validateProvider($request);
        $request->session()->flush();
        
        return Socialite::driver($provider)->redirect();
    }
 
    public function callbackGoogle(Request $request)
    {
        $this->validateProvider($request);

        $response = Socialite::with('google')->user();
 
        $user = User::where('email', $response->getEmail())->first();
        if($user){
            Auth::login($user);
            if(Auth::user()->role_name == RoleStudent){
                return redirect()->route('batches');
            }
            else{
                return redirect()->route('home');
            }
        }
        else{
            Session::flash('alert-message','No account found for provided google credentials.');
            Session::flash('alert-class','warning');
            return redirect()->route('login');
        }
    }
    
 
    public function callbackFB(Request $request)
    {
        $this->validateProvider($request);
        $response = Socialite::driver('facebook')->user();

        $user = User::where('email', $response->getEmail())->first();
        if($user){
            Auth::login($user);
            if(Auth::user()->role_name == RoleStudent){
                return redirect()->route('batches');
            }
            else{
                return redirect()->route('home');
            }
        }
        else{
            Session::flash('alert-message','No account found for provided facebook credentials.');
            Session::flash('alert-class','warning');
            return redirect()->route('login');
        }
    }
    
 
    protected function validateProvider(Request $request): array
    {
        return $this->getValidationFactory()->make(
            $request->route()->parameters(),
            ['provider' => 'in:facebook,google']
        )->validate();
    }
}
