<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Mail;
use App\Mail\BulkMail;
use Session;
use Validator;


class BulkMailController extends Controller
{
    public function showForm()
    {
        $students = \App\Models\Students::all();
        $tutors = \App\Models\Tutors::all();
        return view('bulk_mail', compact('students', 'tutors'));
    }

    public function send(Request $request)
    {
        // $request->validate([
        //     'subject' => 'required|string|max:255',
        //     'message' => 'required|string',
        //     'students' => 'array',
        //     'tutors' => 'array',
        // ]);
        $recipientType = $request->recipient_type;
        if ($recipientType === 'student' && $request->students) {
            $users = User::whereIn('id', $request->students)->get();
        } elseif ($recipientType === 'tutor' && $request->tutors) {
            $users = User::whereIn('id', $request->tutors)->get();
        } else {
            $users =null;
        }
        if ($users) foreach ($users as $user) {
            if ($user->email) {
                Mail::to($user->email)->send(new BulkMail($request->subject, $request->message));
            }
        }
        Session::flash('alert-message', 'Email sent successfully');
        Session::flash('alert-class', 'success');
        return redirect()->route('bulk.mail');
    }
}
