<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Spatie\Activitylog\Models\Activity;
use App\Models\Lessons;
use App\Models\Students;
use App\Models\Batches;
use App\Models\Tutors;
use App\Models\StudentAttendances;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(){
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(){
        $data                        = [];
        $data['lessons']             = [];
        $data['total_lessons']       = 0;
        $data['total_batches']       = 0;
        $data['total_students']      = 0;
        $data['total_tutors']        = 0;
        $data['planned_lessons']     = 0;
        $data['in_progress_lessons'] = 0;
        $data['completed_lessons']   = 0;
        $data['cancelled_lessons']   = 0;
        $weekly_attendances          = [];
        $time_spent_query            = "";
        $tutor_earning_query         = "";
        try {
            $user = Auth::user();
            if($user->role_name == RoleTutor){ 
                $tutor = Tutors::where('user_id', $user->id)->first();
                $batchIds = $tutor->batches->map(function ($batch) { return $batch->id; })->toArray();
                if($tutor){
                    $data['activities']         = Activity::where('causer_id', $user->id)->orderBy('created_at', 'DESC')->take(5)->get();
                    $data['lessons']            = Lessons::whereIn('batch_id', $batchIds)->where('start_date', '>', now() )->take(3)->get();
                    $data['total_lessons']      = Lessons::whereIn('batch_id', $batchIds)->whereNull('deleted_at')->count();
                    $data['total_batches']      = Batches::whereIn('id', $batchIds)->whereNull('deleted_at')->count();
                    $data['total_students']     = Students::whereNull('deleted_at')->count();
                    $data['total_tutors']       = Tutors::whereNull('deleted_at')->count();
                    $data['planned_lessons']    = Lessons::whereIn('batch_id', $batchIds)->where('status', LessonStatusPlanned)->whereNull('deleted_at')->get();
                    $data['in_progress_lessons'] = Lessons::whereIn('batch_id', $batchIds)->where('status', LessonStatusInProgress)->whereNull('deleted_at')->get();
                    $data['completed_lessons']   = Lessons::whereIn('batch_id', $batchIds)->whereIn('status', [LessonStatusCompleted, LessonStatusReportGenerated])->whereNull('deleted_at')->get();
                    $data['cancelled_lessons']   = Lessons::whereIn('batch_id', $batchIds)->where('status', LessonStatusCancelled)->whereNull('deleted_at')->get();
                    $weekly_attendances = StudentAttendances::where('created_by',$user->id)->whereBetween('created_at', 
                                        [
                                            Carbon::now()->subDays(6)->format('Y-m-d')." 00:00:00", 
                                            Carbon::now()->format('Y-m-d')." 23:59:59"
                                        ])
                                        ->where('status', 1)
                                        ->groupBy('date')
                                        ->orderBy('date')
                                        ->get([
                                            DB::raw('DATE_FORMAT(created_at, "%a") as date'),
                                            DB::raw('count(id) as total')
                                        ])->toArray();

                    $time_spent_query = "SELECT SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(end_date, start_date)))) as time_spent "
                            ." FROM lessons "
                            ." WHERE batch_id IN (".Arr::join($batchIds, ', ').") AND status IN (2,4);";

                            
                    $tutor_earning_query = "SELECT SUM(charge) as earning FROM lessons WHERE batch_id IN (".Arr::join($batchIds, ', ').") AND status = 4;";

                    if(Lessons::whereNull('deleted_at')->count() && count($batchIds) > 0){            
                        $data['lessons_time_spent'] = DB::select($time_spent_query)[0]->time_spent 
                                                        ? explode(':', DB::select($time_spent_query)[0]->time_spent)
                                                         : [0, 0];        
                        $data['tutor_earnings']     = DB::select($tutor_earning_query)[0]->earning
                                                         ? DB::select($tutor_earning_query)[0]->earning
                                                         : 0;
                    }
                    else{
                        $data['lessons_time_spent'] = [0, 0];        
                        $data['tutor_earnings']     = 0;
                    }
                }
            }
            else {
                $data['activities']         = Activity::orderBy('created_at', 'DESC')->take(5)->get();
                $data['lessons']            = Lessons::where('start_date', '>', now() )->take(5)->get();
                $data['total_lessons']      = Lessons::whereNull('deleted_at')->count();
                $data['total_batches']      = Batches::whereNull('deleted_at')->count();
                $data['total_students']     = Students::whereNull('deleted_at')->count();
                $data['total_tutors']       = Tutors::whereNull('deleted_at')->count();
                $data['planned_lessons']    = Lessons::where('status', LessonStatusPlanned)->whereNull('deleted_at')->get();
                $data['in_progress_lessons'] = Lessons::where('status', LessonStatusInProgress)->whereNull('deleted_at')->get();
                $data['completed_lessons']   = Lessons::whereIn('status', [LessonStatusCompleted, LessonStatusReportGenerated])->whereNull('deleted_at')->get();
                $data['cancelled_lessons']   = Lessons::where('status', LessonStatusCancelled)->whereNull('deleted_at')->get();
                $weekly_attendances = StudentAttendances::whereBetween('created_at', [Carbon::now()->subDays(6)->format('Y-m-d')." 00:00:00", Carbon::now()->format('Y-m-d')." 23:59:59"])
                                ->where('status', 1)
                                ->groupBy('date')
                                ->orderBy('date')
                                ->get([
                                    DB::raw('DATE_FORMAT(created_at, "%a") as date'),
                                    DB::raw('count(id) as total')
                                ])->toArray();

                $time_spent_query = "SELECT SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(end_date, start_date)))) as time_spent "
                                ." FROM lessons "
                                ." WHERE status IN (2,4);";
                $tutor_earning_query = "SELECT SUM(charge) as earning FROM lessons WHERE status = 4;";
                
                if(Lessons::whereNull('deleted_at')->count()){            
                    $data['lessons_time_spent'] = DB::select($time_spent_query)[0]->time_spent 
                                                    ? explode(':', DB::select($time_spent_query)[0]->time_spent)
                                                     : [0, 0];        
                    $data['tutor_earnings']     = DB::select($tutor_earning_query)[0]->earning
                                                     ? DB::select($tutor_earning_query)[0]->earning
                                                     : 0;
                }
                else{
                    $data['lessons_time_spent'] = [0, 0];        
                    $data['tutor_earnings']     = 0;
                }
            } 

            $data['weekly_attendances'] = json_encode($weekly_attendances);
            $data['all_tutors']         = Tutors::whereNull('deleted_at')->get();
            $data['page_title']         = 'Home';
    
            return view('home',$data);
        } catch (\Exception $e) {
            return abort(404);
        }
    }

    public function activities(){
        try {
            $data = [];
            $data['page_title'] = 'Activity Log';
            $data['activities'] = Activity::orderBy('created_at', 'DESC')->take(100)->get();
            return view('activities.index',$data);
        } catch (\Exception $e) {
            return abort(404);
        }
    }
}
