<?php
 namespace App\Http\Controllers; use App\Jobs\SendEmailJob; use Illuminate\Http\Request; use App\Models\Meeting; use App\Models\MeetingParticipants; use Illuminate\Support\Facades\DB; use Illuminate\Support\Facades\Auth; use stdClass; use Illuminate\Support\Facades\App; use App\Models\Plan; use App\Models\Lessons; use App\Models\Tutors; use Illuminate\Support\Facades\File; class MeetingController extends Controller { public function __construct() { $this->middleware("\x61\165\x74\150", array("\145\x78\143\145\x70\164" => array("\x6d\145\145\x74\x69\156\147", "\x63\x68\145\143\x6b\115\145\x65\164\151\x6e\x67", "\143\x68\x65\x63\x6b\115\x65\145\164\x69\156\147\120\x61\x73\x73\167\157\x72\x64", "\147\x65\164\x44\145\164\141\151\x6c\163", "\163\x65\x74\114\157\x63\x61\154\145", "\x77\x69\x64\x67\x65\x74", "\x63\150\x65\143\x6b\104\x65\x74\141\151\x6c\163"))); if (getSetting("\126\x45\x52\x49\106\x59\x5f\x55\123\x45\x52\x53") == "\145\x6e\x61\142\x6c\x65\144") { $this->middleware("\x63\165\163\x74\x6f\x6d\x56\145\162\x69\x66\151\145\x64", array("\x65\170\143\145\x70\x74" => "\x73\145\x74\114\157\x63\x61\x6c\145")); } } public function index(Request $request) { $meetings = DB::table("\x6d\145\145\164\x69\156\147\x73")->where("\165\x73\x65\162\137\151\144", Auth::id())->orderBy("\151\144", "\x44\105\x53\103")->get(); $contacts = Auth::user()->contact; return view("\x64\141\x73\150\x62\x6f\x61\x72\x64", array("\160\141\x67\145" => __("\x44\141\x73\150\x62\x6f\x61\162\144"), "\x6d\x65\x65\x74\x69\x6e\x67\x73" => $meetings, "\146\151\x72\163\x74\x4d\x65\145\x74\151\156\x67" => !$meetings->isEmpty() ? $meetings[0] : array(), "\164\151\155\145\172\x6f\x6e\x65\x73" => json_decode(file_get_contents(public_path() . "\57\x73\x6f\165\162\x63\145\x73\x2f\164\151\155\145\172\157\156\145\163\56\x6a\x73\157\156"), true), "\164\151\x6d\145\114\x69\x6d\151\164" => getUserPlanFeatures(Auth::id())->time_limit, "\x63\x6f\x6e\x74\x61\x63\164\x73" => $contacts)); } public function createMeeting(Request $request) { $request->validate(array("\155\145\x65\164\x69\x6e\x67\x5f\x69\x64" => "\162\145\x71\x75\x69\x72\145\144\174\x75\156\151\x71\165\x65\x3a\155\145\145\164\151\x6e\147\x73", "\164\x69\164\x6c\x65" => "\x72\145\x71\165\151\x72\x65\x64\174\x6d\141\170\72\61\x30\x30", "\x64\x65\163\x63\x72\151\160\164\x69\x6f\x6e" => "\x6d\x61\170\x3a\x31\x30\60\60")); $meeting = new Meeting(); $meeting->meeting_id = $request->meeting_id; $meeting->title = $request->title; $meeting->description = $request->description; $meeting->user_id = Auth::id(); $meeting->password = $request->password; $meeting->date = $request->date; $meeting->time = $request->time; $meeting->timezone = $request->timezone; if ($meeting->save()) { $meeting->date = formatDate($meeting->date); $meeting->time = formatTime($meeting->time); return json_encode(array("\x73\x75\143\143\145\163\x73" => true, "\x64\141\x74\141" => $meeting)); } return json_encode(array("\163\165\143\143\145\x73\x73" => false)); } public function deleteMeeting(Request $request) { $meeting = Meeting::find($request->id); if ($meeting->delete()) { return json_encode(array("\x73\x75\143\143\145\x73\x73" => true)); } return json_encode(array("\x73\x75\143\143\x65\163\163" => false)); } public function editMeeting(Request $request) { $request->validate(array("\x74\x69\164\154\145" => "\162\x65\x71\x75\x69\162\x65\144")); $meeting = Meeting::find($request->id); $meeting->title = $request->title; $meeting->description = $request->description; $meeting->password = $request->password; $meeting->date = $request->date; $meeting->time = $request->time; $meeting->timezone = $request->timezone; if ($meeting->save()) { $meeting->date = formatDate($meeting->date); $meeting->time = formatTime($meeting->time); return json_encode(array("\x73\x75\x63\x63\x65\x73\x73" => true, "\x64\141\x74\141" => $meeting)); } return json_encode(array("\x73\165\x63\x63\x65\x73\x73" => false)); } public function sendInvite(Request $request) { $newEmails = json_decode($request->emails); $meeting = Meeting::find($request->id); $oldEmails = explode("\x2c", $meeting->invites); $allEmails = array_unique(array_merge($oldEmails, $newEmails), SORT_REGULAR); $meeting->invites = implode("\54", $allEmails); if ($meeting->save()) { dispatch(new SendEmailJob($meeting, $newEmails)); return json_encode(array("\x73\165\x63\143\x65\163\x73" => true)); } return json_encode(array("\163\165\143\x63\x65\163\x73" => false)); } public function getInvites(Request $request) { $meeting = Meeting::find($request->id); if ($meeting) { return json_encode(array("\x73\165\143\143\145\163\x73" => true, "\x64\x61\164\141" => $meeting->invites ? explode("\x2c", $meeting->invites) : array())); } return json_encode(array("\x73\x75\143\x63\x65\163\x73" => false)); } public function checkMeeting(Request $request) { if (getSetting("\x41\125\x54\110\x5f\115\117\x44\x45") == "\x64\151\163\141\x62\x6c\145\144") { return json_encode(array("\x73\165\x63\143\x65\163\163" => true, "\x69\144" => $request->id)); } $meeting = Meeting::where(array("\155\x65\x65\164\151\x6e\147\x5f\x69\x64" => $request->id, "\x73\164\141\164\165\x73" => "\141\143\164\151\x76\145"))->first(); if ($meeting) { return json_encode(array("\x73\165\x63\x63\x65\163\x73" => true, "\x69\144" => $request->id)); } return json_encode(array("\163\x75\143\x63\145\163\x73" => false)); } public function meeting($id) { $meeting = new \stdClass(); if (getSetting("\101\x55\124\x48\137\x4d\117\104\x45") == "\x65\x6e\x61\x62\x6c\x65\x64") { $meeting = Meeting::where(array("\x6d\145\145\164\151\x6e\147\x5f\x69\144" => $id, "\163\164\x61\x74\x75\163" => "\x61\x63\x74\x69\166\145"))->first(); $lesson = Lessons::where("\151\144", $meeting->lesson_id)->first(); $meeting->lessonId = $lesson->id; $meeting->title = $lesson->batch->name . "\x20\55\x20" . $lesson->name; $meeting->batch = $lesson->batch->name; $meeting->lesson = $lesson->name; $meeting->tutor = $lesson->batch->tutor->full_name; $meeting->start_date = date(config("\143\157\156\x73\x74\141\156\x74\56\x64\141\164\145\x5f\146\x6f\x72\155\141\x74\137\156\x65\167"), strtotime($lesson->start_date)); $meeting->duration = date_diff_in_min($lesson->start_date, $lesson->end_date); if (!$meeting) { return redirect("\57")->withErrors(__("\x54\x68\145\x20\x6d\145\x65\x74\x69\x6e\x67\40\144\157\x65\x73\x20\x6e\157\164\x20\x65\x78\x69\163\x74")); } } else { $meeting->title = __("\x4d\145\x65\164\151\156\x67"); $meeting->batch = __("\x42\141\164\x63\x68"); $meeting->lesson = __("\x4c\x65\163\x73\157\155"); $meeting->lessonId = 0; $meeting->tutor = ''; $meeting->meeting_id = $id; $meeting->description = "\x2d"; $meeting->password = null; $meeting->user_id = 0; $meeting->start_date = ''; $meeting->end_date = ''; } $user = Auth::user(); $meeting->features = json_decode("\173\42\x74\x65\170\x74\x5f\x63\x68\x61\164\x22\x3a\x22\61\42\x2c\x22\x66\151\154\x65\137\x73\x68\x61\162\x65\x22\x3a\x22\x31\42\54\42\163\143\x72\145\x65\x6e\x5f\x73\150\141\162\145\42\x3a\x22\x31\42\54\x22\167\x68\151\164\x65\142\x6f\x61\162\144\x22\72\42\x31\42\54\x22\150\141\x6e\x64\137\x72\x61\151\163\145\x22\x3a\x22\x31\x22\54\x22\155\145\145\164\151\x6e\x67\x5f\x6e\157\x22\72\42\x35\x30\x22\x2c\42\x74\151\155\145\137\154\151\155\151\164\42\x3a\42\66\60\x22\54\x22\x72\x65\x63\157\x72\144\x69\156\147\x22\x3a\x22\61\42\x7d", true); $meeting->isTutor = $user && getSetting("\115\117\104\105\122\101\124\x4f\122\137\x52\x49\x47\110\x54\123") == "\x65\156\x61\142\x6c\x65\144" ? $user->role_name == RoleTutor : false; $meeting->userId = $user->id; $meeting->username = $user ? $user->name . ($meeting->isTutor ? "\40\55\x20" . __("\124\x75\164\157\162") : '') : $user->name; $meeting->timeLimit = $meeting->features["\x74\x69\x6d\145\x5f\x6c\x69\x6d\x69\x74"]; $meeting->userLimit = $meeting->features["\165\163\x65\162\x5f\154\x69\155\x69\x74"] ?? 50; $meeting->isAdmin = $user && getSetting("\115\x4f\104\x45\x52\x41\124\x4f\x52\x5f\122\x49\x47\x48\x54\x53") == "\x65\x6e\141\x62\154\x65\x64" ? $user->role_name == RoleSuperAdmin || $user->role_name == RoleAdmin : false; return view("\x6d\x65\x65\164\x69\x6e\147\x2e\x68\x6f\x6d\x65", array("\x70\141\x67\145" => __("\x4d\x65\x65\164\151\x6e\147"), "\155\x65\145\x74\x69\156\x67" => $meeting)); } public function checkMeetingPassword(Request $request) { $meeting = Meeting::find($request->id); if ($meeting->password == $request->password) { return json_encode(array("\x73\x75\143\x63\145\x73\x73" => true)); } return json_encode(array("\x73\165\143\143\x65\163\163" => false)); } public function joinMeeting(Request $request) { $user_id = Auth::user()->id; $meeting = Meeting::find($request->id); if ($meeting) { $isUserCurrentlyActiveInMeeting = MeetingParticipants::where("\x75\163\x65\x72\137\x69\x64", $user_id)->where("\155\x65\x65\x74\x69\x6e\147\x5f\x69\144", $meeting->id)->exists(); if ($isUserCurrentlyActiveInMeeting) { return json_encode(array("\x73\x75\x63\143\x65\163\163" => false)); } else { $participant = new MeetingParticipants(); $participant->meeting_id = $meeting->id; $participant->user_id = $user_id; $participant->save(); return json_encode(array("\x73\x75\143\143\145\163\x73" => true)); } } return json_encode(array("\x73\165\143\143\x65\x73\163" => false)); } public function leaveMeeting(Request $request) { $user_id = $request->user_id; $meeting = Meeting::find($request->meeting_id); if ($meeting) { MeetingParticipants::where("\165\163\x65\x72\137\x69\144", $user_id)->where("\155\x65\x65\164\x69\x6e\x67\137\151\144", $meeting->id)->delete(); return json_encode(array("\163\x75\x63\x63\x65\163\163" => true)); } return json_encode(array("\163\x75\143\143\145\163\163" => false)); } public function leaveMeetingForAll(Request $request) { $meeting = Meeting::find($request->meeting_id); if ($meeting) { MeetingParticipants::where("\x6d\145\145\164\151\156\147\137\x69\x64", $meeting->id)->delete(); return json_encode(array("\x73\165\x63\143\145\x73\163" => true)); } return json_encode(array("\163\165\143\x63\145\163\x73" => false)); } public function getDetails() { $details = new stdClass(); $details->defaultUsername = getSetting("\x44\x45\x46\101\125\x4c\124\x5f\125\x53\x45\x52\x4e\x41\115\x45"); $details->appName = getSetting("\x41\x50\x50\x4c\111\103\x41\124\111\117\x4e\137\116\101\x4d\105"); $details->signalingURL = getSetting("\x53\x49\x47\x4e\101\x4c\x49\x4e\x47\137\x55\x52\x4c"); $details->authMode = getSetting("\101\x55\124\x48\137\115\117\104\x45"); $details->moderatorRights = getSetting("\x4d\x4f\104\x45\122\101\x54\x4f\122\x5f\x52\111\107\110\124\x53"); $details->endURL = getSetting("\x45\116\104\x5f\125\x52\x4c"); return json_encode(array("\x73\165\x63\x63\x65\163\x73" => true, "\x64\x61\x74\x61" => $details)); } public function setLocale(Request $request) { $locale = $request->locale; session(array("\x6c\x6f\143\x61\154\145" => $locale)); App::setLocale($locale); return redirect()->back(); } public function widget() { return view("\155\145\145\x74\x69\x6e\x67\56\167\x69\x64\x67\x65\164"); } public function instant(Request $request) { $allowedMeetings = getUserPlanFeatures(Auth::id())->meeting_no; if ($allowedMeetings != -1 && count(Auth::user()->meeting) >= $allowedMeetings) { return redirect()->route("\x64\x61\163\150\x62\157\x61\x72\144")->withErrors(__("\x59\157\x75\40\150\141\166\145\x20\162\145\x61\x63\150\145\x64\x20\164\150\145\x20\x6d\x61\x78\151\x6d\165\x6d\40\x6d\x65\145\164\x69\156\147\x20\143\162\x65\141\x74\151\x6f\x6e\40\154\x69\x6d\x69\x74\56\x20\125\160\x67\162\141\x64\x65\x20\156\x6f\167")); } $meeting = new Meeting(); $meeting->meeting_id = $request->id; $meeting->title = __("\x4d\145\x65\164\151\x6e\x67") . "\40" . $request->date; $meeting->user_id = Auth::id(); $meeting->save(); return redirect("\x2f\x6d\x65\145\164\x69\156\147\x2f" . $meeting->meeting_id); } public function checkDetails() { $license_notifications_array = aplVerifyLicense('', true); if ($license_notifications_array["\x6e\157\164\x69\x66\151\143\141\x74\x69\157\x6e\137\143\x61\163\145"] == "\x6e\157\x74\151\x66\151\x63\x61\164\x69\157\x6e\137\x6c\x69\x63\x65\x6e\163\145\x5f\x6f\x6b") { return true; } else { return false; } } public function showPage($id) { $page = new \stdClass(); if ($id == "\164\x68\x61\156\153\x2d\x79\x6f\x75") { $page->title = "\x54\x68\141\x6e\153\x20\x59\x6f\165"; $page->slug = "\x74\150\141\156\x6b\55\x79\157\x75"; $page->footer = "\x6e\157"; $page->content = "\124\x68\141\156\153\x20\x79\x6f\165\x20\146\x6f\162\x20\x70\x61\x72\x74\151\143\151\160\x61\164\151\156\147\40\151\x6e\x20\x74\x68\x65\x20\x6d\x65\x65\x74\151\156\x67\x21"; } return view("\155\x65\x65\164\x69\156\x67\x2e\x70\x61\147\145\163", array("\160\141\x67\x65" => $page)); } public function sanitize_string($string) { $special_chars = array("\x3f", "\x5b", "\135", "\57", "\x5c", "\75", "\74", "\x3e", "\72", "\x3b", "\54", "\47", "\42", "\x26", "\44", "\43", "\x2a", "\x28", "\51", "\174", "\x7e", "\x60", "\41", "\x7b", "\175", "\45", "\53", chr(0)); return preg_replace("\x2f\x5b\x5c\162\134\156\x5c\164\x20\x2d\135\53\57", "\137", $string); } public function uploadRecording(Request $request) { try { $meeting = Meeting::where(array("\151\x64" => $request->id))->with("\x6c\145\163\x73\157\156")->first(); if ($meeting) { $lesson = $meeting->lesson; $batch = $lesson->batch; $tutor = Tutors::where("\151\144", $batch->tutor_id)->first(); $tutor_folder_path = public_path(config("\x63\x6f\156\x73\164\141\x6e\164\x2e\x72\x65\x63\x6f\x72\144\151\x6e\x67\x73") . $this->sanitize_string($tutor->full_name)); if (!file_exists($tutor_folder_path)) { mkdir($tutor_folder_path, 448); } $batch_folder_path = public_path(config("\x63\157\x6e\163\x74\x61\x6e\164\56\x72\145\x63\x6f\162\x64\x69\156\147\x73") . $this->sanitize_string($tutor->full_name) . "\x2f" . $this->sanitize_string($batch->name)); if (!file_exists($batch_folder_path)) { mkdir($batch_folder_path, 448); } $lesson_folder_path = public_path(config("\143\157\x6e\163\x74\141\x6e\x74\56\162\x65\x63\157\x72\x64\x69\156\x67\163") . $this->sanitize_string($tutor->full_name) . "\x2f" . $this->sanitize_string($batch->name) . "\57" . $this->sanitize_string($lesson->name)); if (!file_exists($lesson_folder_path)) { mkdir($lesson_folder_path, 448); } if (!file_exists($lesson_folder_path . "\57" . $request->fileName)) { $file = fopen($lesson_folder_path . "\57" . $request->fileName, "\x77"); fclose($file); } $chunk = $request->has("\x63\x68\x75\156\x6b") ? htmlspecialchars($request->chunk) : ''; $mp4 = $lesson_folder_path . "\x2f" . $request->fileName; file_put_contents($mp4, base64_decode($chunk), FILE_APPEND); return response()->json(array("\163\x75\143\x63\145\163\163" => true, "\155\x65\x73\163\141\147\x65" => "\125\160\x6c\157\141\144\137\123\165\x63\x63\x65\163\x73"), 200); } } catch (Exception $e) { return response()->json(array("\x73\x75\x63\x63\145\163\163" => false, "\x6d\145\163\x73\x61\x67\145" => $e->getMessage()), 200); } } }