<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class FeeReminderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $batch, $student;

    /**
     * Create a new message instance.
     */
    public function __construct($batch, $student)
    {
        $this->batch = $batch;
        $this->student = $student;
    }

    /**
     * Get the message envelope.
     */
    public function build()
    {
        return $this->subject("Fee Reminder | ".config('app.name'))->markdown('mails.fee_reminder')
            ->with([
            'batch' => $this->batch,
            'student' => $this->student
        ]);
    }
}
