<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PaymentOrderGeneratedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user, $purchaseOrder;

    /**
     * Create a new message instance.
     */
    public function __construct($purchaseOrder)
    {
        $this->user = $user;
        $this->purchaseOrder = $purchaseOrder;
    }

    /**
     * Get the message envelope.
     */
    public function build()
    {
        return $this->subject("Payment Order Generated | ".config('app.name'))->markdown('mails.po_generate')
            ->with([
            'user' => $this->user,
            'paymentOrder' => $this->paymentOrder
        ]);
    }
}
