<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Batches extends Model{

    use SoftDeletes;
    use LogsActivity;
    
    protected static $logAttributes = '*';
    protected static $logFillable   = true;
    protected static $logOnlyDirty  = true;
    protected static $logName       = 'Batches';
    protected $primaryKey           = "id";

    protected $table                = 'batches';
    protected $fillable             = [
        'name', 'description','batch_type', 'tutor_id', 'max_lessons',
        'created_at','created_by', 'updated_at','updated_by','deleted_by','deleted_at'
    ];

    public $timestamps              = false;
    protected $dates                = ['deleted_at'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }
    public function students(){
        return $this->belongsToMany(Students::class, 'batch_students');
    }
    public function tutor(){
        return $this->belongsTo(Tutors::class,'tutor_id','id');
    }
    public function lessons(){
        return $this->hasMany(Lessons::class,'batch_id','id');
    }
    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function _updated_by(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
}
