<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Permissions extends Model{
    
	use SoftDeletes;
    
    protected static $logAttributes    = '*';
    protected static $logFillable      = true;
    protected static $logOnlyDirty     = true;
    protected static $logName          = 'Permission';

	protected $table                   = 'permissions';
    protected $fillable                = [
        'name','display_name','guard_name','created_at','created_by','updated_at','updated_by','deleted_by','deleted_at'
    ];
    public $timestamps                  = false;
    protected $dates                    = ['deleted_at'];
}