<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class StudentAttendances extends Model{

    use SoftDeletes;
    use LogsActivity;
    
    protected static $logAttributes = '*';
    protected static $logFillable   = true;
    protected static $logOnlyDirty  = true;
    protected static $logName       = 'StudentAttendances';
    protected $primaryKey           = "id";

    protected $table                = 'student_attendances';
    protected $fillable             = [
        'student_id', 'lesson_id', 'status', 'created_at','created_by',
        'updated_at','updated_by','deleted_by','deleted_at'
    ];

    public $timestamps              = false;
    protected $dates                = ['deleted_at'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }
    
    public function student(){
        return $this->belongsTo(Students::class,'student_id','id');
    }
    public function lesson(){
        return $this->belongsTo(Lessons::class,'lesson_id','id');
    }
    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function _updated_by(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
}
