<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class TicketTimelines extends Model{

    use SoftDeletes;
    use LogsActivity;
    
    protected static $logAttributes = '*';
    protected static $logFillable   = true;
    protected static $logOnlyDirty  = true;
    protected static $logName       = 'TicketTimeline';
    protected $primaryKey           = "id";

    protected $table                = 'ticket_timelines';
    protected $fillable             = [
        'ticket_id', 'comments', 'created_by', 'created_at', 'updated_at', 'updated_by'
    ];

    public $timestamps              = false;
    protected $dates                = ['deleted_at'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }

    public function ticket(){
        return $this->belongsTo(Ticket::class,'ticket_id','id');
    }
    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function _deleted_by(){
        return $this->belongsTo(User::class,'deleted_by','id');
    }
}
