<?php
use Illuminate\Support\Facades\Cache;
use App\Models\GlobalConfig;
use App\Models\Language;

if (!defined('LessonStatusPlanned')) define("LessonStatusPlanned", 0);
if (!defined('LessonStatusInProgress')) define("LessonStatusInProgress", 1);
if (!defined('LessonStatusCompleted')) define("LessonStatusCompleted", 2);
if (!defined('LessonStatusCancelled')) define("LessonStatusCancelled", 3);
if (!defined('LessonStatusReportGenerated')) define("LessonStatusReportGenerated", 4);

if (!defined('RoleTutor')) define("RoleTutor", "tutor");
if (!defined('RoleAdmin')) define("RoleAdmin", "admin");
if (!defined('RoleSuperAdmin')) define("RoleSuperAdmin", "super-admin");
if (!defined('RoleStudent')) define("RoleStudent", "student");

if (!defined('TicketStatusCreated')) define("TicketStatusCreated", 0);
if (!defined('TicketStatusAssigned')) define("TicketStatusAssigned", 1);
if (!defined('TicketStatusClosed')) define("TicketStatusClosed", 2);
if (!defined('TicketStatusReopen')) define("TicketStatusReopen", 3);

if (!defined('TicketPriorityLow')) define("TicketPriorityLow", 0);
if (!defined('TicketPriorityMedium')) define("TicketPriorityMedium", 1);
if (!defined('TicketPriorityHigh')) define("TicketPriorityHigh", 2);

if (!defined('PaymentOrderStatusRaised')) define("PaymentOrderStatusRaised", 0);
if (!defined('PaymentOrderStatusPaid')) define("PaymentOrderStatusPaid", 1);

if(! function_exists('getSqlWithBindings')){
    function getSqlWithBindings($query)
    {
        return vsprintf(str_replace('?', '%s', $query->toSql()), collect($query->getBindings())->map(function ($binding) {
            return is_numeric($binding) ? $binding : "'{$binding}'";
        })->toArray());
    }
}
if(! function_exists('get_activity_details')){
    function get_activity_details($activity)
    {
        $causer = \App\Models\User::where('id',$activity->causer_id)->first();
        
        $causer_url =  route("users.view",$activity->causer_id);
        $subject_url = "";
        $subject = "";
        $action = "";
        $description_lg = $activity->description;
        $description = $activity->description;

        if($activity->subject_type == 'App\Models\Roles'){
            $subject_url = route("roles.view",$activity->subject_id);
            $subject = 'Role';
        }
        if($activity->subject_type == 'App\Models\Permissions'){
            $subject_url = route("permissions.view",$activity->subject_id);
            $subject = 'Permission';
        }
        if($activity->subject_type == 'App\Models\Students'){
            $subject_url = route("students.view",$activity->subject_id);
            $subject = 'Student';
        }
        if($activity->subject_type == 'App\Models\Tutors'){
            $subject_url = route("tutors.view",$activity->subject_id);
            $subject = 'Tutor';
        }
        if($activity->subject_type == 'App\Models\Admins'){
            $subject_url = route("admins.view",$activity->subject_id);
            $subject = 'Admin';
        }
        if($activity->subject_type == 'App\Models\Batches'){
            $subject_url = route("batches.view",$activity->subject_id);
            $subject = 'Batch';
        }
        if($activity->subject_type == 'App\Models\Lessons'){
            $subject_url = route("lessons.view",$activity->subject_id);
            $subject = 'Lesson';
            if($activity->description == "status_updated"){
                $description_lg = "updated status of ";
                $description = " updated ";
            }
        }
        if($activity->subject_type == 'App\Models\StudentAttendances'){
            $attendance = \App\Models\StudentAttendances::where('id', $activity->subject_id)->first();
            if($attendance){
                $subject_url = route("lessons.view",$attendance->lesson_id);
            }
            $subject = 'Student Attendance';
        }

        return [
            'causer' => $causer->name,
            'causer_url' => $causer_url,
            'subject' => $subject,
            'subject_url' => $subject_url,
            'description' => $description,
            'description_lg' => $description_lg,
            'created_at' => $activity->created_at
        ];
    }
}
if(! function_exists('date_diff_in_min')){
    function date_diff_in_min($start_date, $end_date)
    {
        $start  = new Carbon\Carbon($start_date);
        $end    = new Carbon\Carbon($end_date);
        return $start->diff($end)->format('%H hours %I minutes');
    }
    
}
if(! function_exists('get_lesson_status')){
    function get_lesson_status($status)
    {
        $content = '';
        $type = '';
        if($status == 0) {
            $content = "PLANNED";
            $type = 'info';
        }
        else if($status == 1) {
            $content = "IN PROGRESS";
            $type = 'warning';
        }
        else if($status == 2) {
            $content = "COMPLETED";
            $type = 'success';
        }
        else if($status == 3) {
            $content = "CANCELLED";
            $type = 'danger';
        }
        else if($status == 4) {
            $content = "REPORT GENERATED";
            $type = 'primary';
        }
        return [
            'status' => $content,
            'type' => $type
        ];
    }
}
if(! function_exists('getSetting')){
    //get settings from the global config table
    function getSetting($key) {
        $settings = Cache::rememberForever('settings', function () {
            return GlobalConfig::all()->pluck('value', 'key');
        });
        
        if (!$settings[$key]) {
            Cache::forget('settings');
            $settings = GlobalConfig::all()->pluck('value', 'key');
        }
    
        return $settings[$key];
    }
}
if(! function_exists('getUserPlanFeatures')){
    //get features associated with the user ID
    function getUserPlanFeatures($id) {
        $user = User::find($id);
        $planId = $user->plan_id;
    
        if ($user->plan_ends_at == '') {
            $planId = $user->plan_id;
        } else if (date('Y-m-d', strtotime($user->plan_ends_at)) < date('Y-m-d')) {
            $planId = 1;
        }
    
        return Plan::find($planId)->features;
    }
}
if(! function_exists('getLanguages')){
    //get languages
    function getLanguages () {
        $languages = Cache::rememberForever('languages', function () {
            return Language::where(['status' => 'active'])->select('code', 'name', 'default', 'direction')->get();
        });
    
        return $languages;
    }
}
if(! function_exists('getSelectedLanguage')){
    //get selected language
    function getSelectedLanguage () {
        if (session('locale')) {
            $selectedLanguage = getLanguages()->first(function($langauage) {
                return $langauage->code == session('locale');
            });
    
            if ($selectedLanguage) return $selectedLanguage;
        }
    
        return getDefaultLanguage();
    }

}
if(! function_exists('getDefaultLanguage')){
    //get default language
    function getDefaultLanguage() {
        $languages = Cache::rememberForever('defaultLangauage', function () {
            return Language::where(['default' => 'yes'])->select('code', 'name', 'direction')->first();
        });
    
        return $languages;
    }
}
if(! function_exists('isInstalled')){
    //get value
    function isInstalled () {
        return session('installed');
    }
}
if(! function_exists('isDemoMode')){
    //check if the demo mode is enabled
    function isDemoMode () {
        return config('app.demo_mode');
    }
}
if(! function_exists('formatMoney')){
    // Format money.
    function formatMoney($amount, $currency)
    {
        if (in_array(strtoupper($currency), config('currencies.zero_decimals'))) {
            return number_format($amount, 0, __('.'), __(','));
        } else {
            return number_format($amount, 2, __('.'), __(','));
        }
    }
}
if(! function_exists('paymentGateways')){
    // Get the enabled payment gateways.
    function paymentGateways()
    {
        $paymentGateways = config('payment.gateways');
        foreach ($paymentGateways as $key => $value) {
            if (!getSetting($key)) {
                unset($paymentGateways[$key]);
            }
        }
    
        return $paymentGateways;
    }
}
if(! function_exists('calculateInclusiveTax')){
    function calculateInclusiveTax($amount, $discount, $inclusiveTaxRate, $inclusiveTaxRates)
    {
        return calculatePostDiscount($amount, $discount) * ($inclusiveTaxRate / 100);
    }
}
if(! function_exists('checkoutTotal')){
    /**
     * Calculate the total, including the exclusive taxes.
     * PostDiscount + ExclusiveTax$
     */
    function checkoutTotal($amount, $discount, $exclusiveTaxRates, $inclusiveTaxRates)
    {	
        return calculatePostDiscount($amount, $discount) + (calculatePostDiscount($amount, $discount) * ($exclusiveTaxRates / 100));
    }
}
if(! function_exists('calculatePostDiscount')){
    /**
     * Returns the amount after discount.
     * Amount - Discount$
     */
    function calculatePostDiscount($amount, $discount)
    {
        return $amount - calculateDiscount($amount, $discount);
    }
}
if(! function_exists('checkoutExclusiveTax')){
    /**
     * Returns the exclusive tax amount.
     * PostDiscountLessInclTaxes * TaxRate
     */
    function checkoutExclusiveTax($amount, $discount, $exclusiveTaxRate, $inclusiveTaxRates)
    {
        // return calculatePostDiscountLessInclTaxes($amount, $discount, $inclusiveTaxRates) * ($exclusiveTaxRate / 100);
        return calculatePostDiscount($amount, $discount) * ($exclusiveTaxRate / 100);
    }
}
if(! function_exists('calculateDiscount')){
    /**
     * Returns the discount amount.
     * Amount * Discount%
     */
    function calculateDiscount($amount, $discount)
    {
        return $amount * ($discount / 100);
    }
}
if(! function_exists('calculatePostDiscountLessInclTaxes')){
    /**
     * Returns the amount after discount and included taxes.
     * PostDiscount - InclusiveTaxes$
     */
    function calculatePostDiscountLessInclTaxes($amount, $discount, $inclusiveTaxRates)
    {
        return calculatePostDiscount($amount, $discount) - calculateInclusiveTaxes($amount, $discount, $inclusiveTaxRates);
    }
}
if(! function_exists('calculateInclusiveTaxes')){
    /**
     * Returns the inclusive taxes amount.
     * PostDiscount - PostDiscount / (1 + TaxRate)
     */
    function calculateInclusiveTaxes($amount, $discount, $inclusiveTaxRate)
    {
        return calculatePostDiscount($amount, $discount) - (calculatePostDiscount($amount, $discount) / (1 + ($inclusiveTaxRate / 100)));
    }
}
if(! function_exists('getPages')){
    //get pages to show in footer
    function getPages()
    {
        return Page::select('title', 'slug')->where('footer', 'yes')->get();
    }
}
if(! function_exists('formatDate')){
    //format date
    function formatDate($date)
    {
        return $date ? date('d-m-Y', strtotime($date)) : '-';
    }
}
if(! function_exists('formatTime')){
    //format time
    function formatTime($time)
    {
        return $time ? date('h:i A', strtotime($time)) : '-';
    }
}

if(! function_exists('generate_po_no')){
	function generate_po_no(){
        $lastPaymentOrder =  \DB::table("payment_orders")->orderBy('id','desc')->first();
        if($lastPaymentOrder){
            $new_id = ($lastPaymentOrder->id+1);
        }
        else{
            $new_id = 1;
        }
        if (date('m') > 6) {
            $year = date('y')."-".(date('y') +1);
        }
        else {
            $year = (date('y')-1)."-".date('y');
        }
        return 'PO/'.$year.'/'.$new_id;
    }
}

if(! function_exists('generate_ticket_no')){
	function generate_ticket_no(){
        $lastTicket =  \DB::table("tickets")->orderBy('id','desc')->first();
        if($lastTicket){
            $new_id = ($lastTicket->id + 1);
        }
        else{
            $new_id = 1;
        }
        if (date('m') > 6) {
            $year = date('y')."-".(date('y') +1);
        }
        else {
            $year = (date('y')-1)."-".date('y');
        }
        return "TKT/".$year.'/'.$new_id;
    }
}
if(! function_exists('unread_ticket_count')){
	function unread_ticket_count(){
        $query = \App\Models\Tickets::query();
        $id = Auth::user()->id;
        $query->where(function ($query) use ($id) {
            $query->where('assigned_to',$id)
                ->where('is_read', 0);
        })->orWhere(function ($query) use ($id) {
            $query->where('assigned_by',$id)
                ->where('is_read', 0);
        });
        return  $query->count();
    }
}
















