@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">Edit Admin</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('admins.store') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST" novalidate="novalidate">
            @csrf
            <input type="hidden" name="id" id="id" value="{{ isset($admin->id) ? $admin->id : '' }}">
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('first_name') is-invalid @enderror">
                    <label class="control-label">First Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="first_name" id="first_name" value="{{ old( 'first_name', isset($admin->first_name) ? $admin->first_name : '') }}" placeholder="First Name Here" maxlength="150">
                    @error('first_name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('last_name') is-invalid @enderror">
                    <label class="control-label">Last Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="last_name" id="last_name" value="{{ old( 'last_name', isset($admin->last_name) ? $admin->last_name : '') }}" placeholder="Last Name Here" maxlength="150">
                    @error('first_name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 fv-plugins-icon-container">
                <div class="form-group @error('email') is-invalid @enderror">
                    <label class="control-label">Email <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="email" id="email" value="{{ old( 'email', isset($admin->user) ? $admin->user->email : '') }}" placeholder="Email Here" maxlength="150" readonly>
                    @error('email')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('admins')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    $(document).ready(function() {
    });
</script>
@endsection