@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('page-style')
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
@endsection

@section('content')

<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">View Admin  </h5>
    </div>
    <div class="card-body pt-4">
        <ul class="list-unstyled my-3 py-1">
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">First Name:</span>
              <span>{{ old( 'first_name', isset($admin->first_name) ? $admin->first_name : '') }}</span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Last Name:</span>
              <span>{{ old( 'last_name', isset($admin->last_name) ? $admin->last_name : '') }}</span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Email:</span>
              <span>{{ old( 'email', isset($admin->user->email) ? $admin->user->email : '') }}</span>
            </li>
        </ul>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    $(document).ready(function() {
    });
</script>
@endsection