@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">{{$header}}</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('batches.lesson.timings.store') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST" novalidate="novalidate">
            @csrf
            <input type="hidden" name="id" id="id" value="{{ isset($lesson->id) ? $lesson->id : '' }}">
            <div class="col-4 fv-plugins-icon-container">
                <div class="form-group @error('start_date') is-invalid @enderror">
                    <label class="control-label">Start Date <span style="color: red">*</span></label>
                    <input type="datetime-local" class="form-control" name="start_date" id="start_date" value="{{ date('Y-m-d\TH:i', strtotime($lesson->start_date)) }}" />
                    @error('start_date')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('batches.view', $batch_id)}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    $(document).ready(function() {
    });
</script>
@endsection