@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('page-style')
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
@endsection

@section('content')

<div class="row mb-10">
  <div class="col-md-4">
    <div class="card h-100">
      <div class="card-header border-bottom">
        <h5 class="card-title mb-0">View Batch</h5>
      </div>
      <div class="card-body pt-4">
        <ul class="list-unstyled my-3 py-1">
          <li class="d-flex align-items-center mb-4">
            <span class="fw-medium mx-2">Name:</span>
            <span>{{ old( 'name', isset($batch->name) ? $batch->name : '') }}</span>
          </li>
          <li class="d-flex align-items-center mb-4">
            <span class="fw-medium mx-2">Description:</span>
            <div>{{ old( 'description', isset($batch->description) ? $batch->description : '') }}</div>
          </li>
          <li class="d-flex align-items-center mb-4">
            <span class="fw-medium mx-2">Tutor:</span>
            <span>
              @if(Auth::user()->role_name != RoleStudent)
              <a href="{{ route('tutors.view', $batch->tutor->id)}}">
                {{ old( 'email', isset($batch->tutor) ? $batch->tutor->full_name : '') }}
              </a>
              @else
                <div>{{ old( 'email', isset($batch->tutor) ? $batch->tutor->full_name : '') }}</div>
              @endif
            </span>
          </li>
        </ul>
        <div class="row">
          <div class="col-md-12">
            @if(Auth::user()->role_name == RoleAdmin || Auth::user()->role_name == RoleSuperAdmin)
              <div class="dt-action-buttons text-xl-end text-lg-start text-md-end text-start d-flex align-items-center justify-content-end flex-md-row flex-column mb-6 mb-md-0 mt-n6 mt-md-0">
                  <div class="dt-buttons btn-group flex-wrap">
                    <form action="{{ route('batches.reminder') }}" class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
                      @csrf
                      <input type="hidden" name="id" id="id" value="{{ $batch->id }}">
                      <button type="submit" class="btn btn-secondary add-new btn-primary waves-effect waves-light" 
                      tabindex="0" ><span><i class="ti ti-currency-rupee me-0 me-sm-1 ti-xs"></i>
                        <span class="d-none d-sm-inline-block">Send Fee Reminder</span></span></a> 
                    </form>  
                  </div>
              </div>
              @endif
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-8">
    <div class="card h-100">
      <div class="card-header d-flex flex-wrap justify-content-between">
        <h4>Students ({{ $batch->students->count() }})</h4>
      </div>
      <div class="card-body" style="height: 350px;overflow: hidden;overflow-y: auto;">
        <div class="row">
          @foreach ($batch->students as $student)
          <div class="col-xl-4 col-lg-5 col-md-4 order-1 order-md-0">
            <!-- Customer-detail Card -->
            <div class="card mb-6">
              <div class="card-body pt-12">
                <div class="customer-avatar-section">
                  <div class="d-flex align-items-center flex-column">
                    <img class="img-fluid rounded mb-4" src="{{ asset('assets/img/avatars/user.png') }}" height="120" width="120" alt="User avatar">
                    <div class="customer-info text-center">
                      <h5 class="mb-0">{{ $student->full_name }}</h5>
                      <p>{{ $student->gender }}</p>
                    </div>
                  </div>
                </div>
    
                @if(Auth::user()->role_name == RoleAdmin || Auth::user()->role_name == RoleSuperAdmin)
                <div class="info-container">
                  <h5 class="pb-4 border-bottom text-capitalize mt-6 mb-4">Details</h5>
                  <ul class="list-unstyled mb-2">
                    <li class="mb-2">
                      <span class="h6 me-1">Parent Name:</span>
                      <span>{{ $student->parent_name }}</span>
                    </li>
                    <li class="mb-2">
                      <span class="h6 me-1">Parent Email:</span>
                      <span>{{ $student->parent_email }}</span>
                    </li>
                    <li class="mb-2">
                      <span class="h6 me-1">Parent Mobile:</span>
                      <span>{{ $student->parent_mobile }}</span>
                    </li>
                  </ul>
                </div>
                @endif
              </div>
            </div>
            <!-- /Customer-detail Card -->
          </div>
          @endforeach
        </div>
      </div>
    </div>
  </div>
</div>
<br/>
<div class="card mb-6">
  <div class="card-header">
    <div class="card-title mb-0 me-1">
      <h5 class="mb-0">Lessons</h5>
      <p class="mb-0">Total {{ $batch->lessons->count() }} lessons are in {{ $batch->name }} batch. </p>
      <br/>
      <ul class="list-unstyled my-3 py-1">
          <li class="d-flex align-items-center mb-4">
            <span class="fw-medium mx-2">Filter Lessons:</span>
            <span>
              <select id="sl-filter-lessons" class="form-select w-25" style="min-width: 200px;">
                <option value=""></option>
                <option value="{{LessonStatusPlanned}}">Planned</option>
                <option value="{{LessonStatusInProgress}}">In Progress</option>
                <option value="{{LessonStatusCompleted}}">Completed</option>
                <option value="{{LessonStatusCancelled}}">Cancelled</option>
                <option value="{{LessonStatusReportGenerated}}">Report Generated</option>
              </select>
            </span>
          </li>
        </ul>
    </div>
  </div>
  <div class="card-body">
    <div class="row gy-6 mb-6">
      @foreach ( $batch->lessons as $lesson )
        @php
          $lesson_status = 'lesson-'.$lesson->status;
          $status = get_lesson_status($lesson->status);
        @endphp
        <div class="col-sm-6 col-lg-4 lesson {{$lesson_status}}">
          <div class="card p-2 h-100 shadow-none border">
            <div class="card-body p-4 pt-2">
              <div class="d-flex justify-content-between align-items-center mb-4">
              </div>
              <a href="{{ route('lessons.view', $lesson->id) }}" class="h4 mb-2">{{ $lesson->name }}</a>
              <p>{{ $batch->name }}</p>
              <div class="row mb-4 g-3">
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-user ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap">{{ $lesson->batch->tutor->full_name }}</h6>
                      <small>Tutor</small>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-calendar-event ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap">{{ date(config('constant.date_format_new'), strtotime($lesson->start_date)) }}</h6>
                      <small>Date</small>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-clock ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap">{{ date_diff_in_min($lesson->start_date, $lesson->end_date)}}</h6>
                      <small>Duration</small>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-progress ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap text-{{ $status ['type']}}">{{ $status['status'] }}</h6>
                      <small>Status</small>
                    </div>
                  </div>
                </div>
              </div>
              @if(Auth::user()->role_name == RoleAdmin || Auth::user()->role_name == RoleSuperAdmin)
                <div class="d-flex flex-column flex-md-row gap-4">
                  <a class="btn btn-primary"  href="{{ route('lessons.view', $lesson->id) }}">
                    <span>Open {{ $lesson->name }}</span>
                  </a>
                  @if(!in_array($lesson->status, [LessonStatusInProgress, LessonStatusCompleted, LessonStatusReportGenerated]))
                    <a class="w-10 btn btn-secondary" href="{{ route('batches.lesson.timings', $lesson->id) }}">
                      <i class="fa fa-pencil"></i>
                    </a>
                    <a class="w-10 btn btn-secondary" href="javscript:void(0);" onclick="deleteRecord({{$lesson->id}})">
                      <i class="fa fa-trash"></i>
                    </a> 
                  @endif
                </div>
              @else
                <div class="d-flex flex-column flex-md-row gap-4">
                  <a class="btn btn-primary"  href="{{ route('lessons.view', $lesson->id) }}">
                    <span>Open {{ $lesson->name }}</span>
                  </a>
                </div>
              @endif
            </div>
          </div>
        </div>
      @endforeach
    </div>
  </div>
</div>
<style>
  .lesson {
    display: none;
  }
</style>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    $(document).ready(function() {
      $('.lesson.lesson-'+{{LessonStatusInProgress}}).show();
      $('#sl-filter-lessons').change(function(){
        status = $(this).val();
        $('.lesson').hide();
        $('.lesson.lesson-'+status).show();
      });
    });
    
    function deleteRecord(id){
      Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes, delete it!',
          confirmButtonColor: "#d33",
          confirmButtonClass: 'btn btn-success',
          cancelButtonText: 'No, cancel!',
          cancelButtonColor: '#3085d6',
          cancelButtonClass: 'btn btn-danger',
          buttonsStyling: true,
          reverseButtons: true
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  type: "POST",
                  headers: {'X-CSRF-Token': Laravel.csrfToken},
                  url: '{!! route("lessons.destroy") !!}',
                  dataType : 'json',
                  data: {id:id},
                  success: function(response) {
                      setTimeout( function () {
                          redrawDatatable();
                      }, 1000 );
                      if(response.success == true){
                        Swal.fire({
                            type : 'success',
                            title: 'Deleted!',
                            text : response.message,
                            timer: '1500'
                        });
                        location.reload();
                      }else{
                        Swal.fire({
                            type : 'error',
                            title: 'Not Deleted!',
                            text : response.message,
                            timer: '1500'
                        });
                      }
                  },
                  error: function (jqXHR, status, exception) {
                      if (jqXHR.status === 0) {
                          error = 'Not connected.\nPlease verify your network connection.';
                      } else if (jqXHR.status == 404) {
                          error = 'The requested page not found. [404]';
                      } else if (jqXHR.status == 500) {
                          error = 'Internal Server Error [500].';
                      } else if (exception === 'parsererror') {
                          error = 'Requested JSON parse failed.';
                      } else if (exception === 'timeout') {
                          error = 'Time out error.';
                      } else if (exception === 'abort') {
                          error = 'Ajax request aborted.';
                      } else {
                          error = 'Uncaught Error.\n' + jqXHR.responseText;
                      }
                      Swal.fire('Error!',error,'error');
                  }
              });
          }
      });
    }
</script>
@endsection