<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ getSelectedLanguage()->direction }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title')</title>

    <!-- Styles -->
    <style type="text/css">
        :root {
            --secondary-color: #536d79;
            --primary-color: {{ getSetting('PRIMARY_COLOR') }};
        }

    </style>
    <link href="{{ asset('assets/meeting/css/app.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/meeting/css/fa.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/meeting/css/toastr.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/meeting/css/style.css') }}" rel="stylesheet">
    <link rel="icon" type="image/png" href="{{ asset('assets/img/favicon/favicon.ico') }}">
    @yield('style')

    <style>
        {!! getSetting('CUSTOM_CSS') !!}
    </style>
    {!! getSetting('CUSTOM_JS') !!}
</head>

<body>
    <div id="app">
        <nav class="navbar navbar-expand-md">
            <a class="navbar-brand" href="{{ url('/') }}" target="_blank">
                <img src="{{ asset('assets/img/logo-small.png') }}"
                    alt="{{ config('app.name') }}" class="logo-inner">
                <span class="app-name">{{ config('app.name') }}</span>
            </a>
        </nav>

        <main class="pt-4 mb-5 mb-md-0">
            @yield('content')
        </main>
    </div>

    <script>
        const cookieConsent = "{{ getSetting('COOKIE_CONSENT') }}";
        const googleAnalyticsTrackingId = "{{ getSetting('GOOGLE_ANALYTICS_ID') }}";
        const socialInvitation = "{{ getSetting('SOCIAL_INVITATION') }}";

        const languages = {
            error_occurred: "{{ __('An error occurred, please try again') }}",
            data_updated: "{{ __('Data updated successfully') }}",
            no_meeting: "{{ __('The meeting does not exist') }}",
            meeting_created: "{{ __('The meeting has been created') }}",
            confirmation: "{{ __('Are you sure') }}",
            meeting_deleted: "{{ __('The meeting has been deleted') }}",
            link_copied: "{{ __('Meeting link has been copied to the clipboard') }}",
            meeting_updated: "{{ __('The meeting has been updated') }}",
            sending_invite: "{{ __('Sending the invitation') }}",
            invite_sent: "{{ __('Invitation has been sent') }}",
            inviteMessage: "{{ __('Hey there! Join me for a meeting at this link') }}",
            no_session: "{{ __('Could not get the session details') }}",
            kicked: "{{ __('You have been kicked out of the meeting') }}",
            uploading: "{{ __('Uploading the file') }}",
            meeting_ended_tutor: "{{ __('The meeting has been ended by the tutor') }}",
            meeting_ended_student: "{{ __('You have come out of the meeting') }}",
            cant_connect: "{{ __('Could not connect to the server, please try again later') }}",
            invalid_password: "{{ __('The password is invalid') }}",
            already_joined: "{{ __('You have already joined the meeting.') }}",
            meeting_join_issue: "{{ __('There was some issue while joining meeting.') }}",
            meeting_leave_issue: "{{ __('There was some issue while leaving meeting.') }}",
            no_device: "{{ __('Could not get the devices, please check the permissions and try again. Error') }}",
            approve: "{{ __('Approve') }}",
            decline: "{{ __('Decline') }}",
            request_join_meeting: "{{ __('Request to join the meeting ') }}",
            allow_at_lease_one_media_to_join: "{{ __('Please allow at leaset one media ( audio or video ) to join the meeting.') }}",
            request_declined: "{{ __('Your request has been declined by the tutor') }}",
            double_click: "{{ __('Double click on the video to make it fullscreen') }}",
            single_click: "{{ __('Single click on the video to turn picture-in-picture mode on') }}",
            error_message: "{{ __('An error occurred') }}",
            kick_user: "{{ __('Kick this user') }}",
            participant_joined: "{{ __('has joined the meeting') }}",
            confirmation_kick: "{{ __('Are you sure you want to kick this user') }}",
            participant_left: "{{ __('A participant has left the meeting') }}",
            camera_on: "{{ __('Camera has been turned on') }}",
            camera_off: "{{ __('Camera has been turned off') }}",
            mic_unmute: "{{ __('Mic has been unmute') }}",
            mic_mute: "{{ __('Mic has been muted') }}",
            no_video: "{{ __('The video is not playing or has no video track') }}",
            no_pip: "{{ __('Picture-in-picture mode is not supported in this browser') }}",
            link_copied: "{{ __('The meeting invitation link has been copied to the clipboard') }}",
            cant_share_screen: "{{ __('Could not share the screen, please check the permissions and try again') }}",
            max_file_size: "{{ __('Maximum file size allowed (MB)') }}",
            view_file: "{{ __('View File') }}",
            hand_raised: "{{ __('have raised hand') }}",
            hand_raised_self: "{{ __('you have raised hand') }}",
            your_screen: "{{ __('Your screen') }}",
            not_started: "{{ __('The meeting has not been started yet') }}",
            meeting_full: "{{ __('The meeting is full') }}",
            please_wait: "{{ __('Please wait while the tutor check your request') }}",
            request_record_meeting: "{{ __('Request to record the meeting') }}",
            record_request_declined: "{{ __('You recording request was not approved') }}",
            feature_not_supported: "{{ __('This feature is not yet supported in your browser') }}",
            feature_not_available: "{{ __('This feature is not available in the current meeting plan') }}",
            leave_meeting_confirmation: "{{ __('Are you sure wants to leave meeting ?') }}",
            reload_page: "{{ __('Are you sure wants to reload the page ?') }}",
            password: "{{ __('Password: ') }}",
            calendar_check: "{{ __('Please set a date and time') }}",
            recording_started: "{{ __('The recording has been started') }}",
            token_copied: "{{ __('API Token has been copied to the clipboard') }}",
            screen: "{{ __('Screen') }}",
            tutor: "{{ __('Tutor') }}",
            you_muted: "{{ __('You muted all the participants') }}",
            you_unmuted: "{{ __('You unmuted all the participants') }}",
            mic_muted_tutor: "{{ __('Mic has been muted by the tutor') }}",
            mic_unmuted_tutor: "{{ __('Mic has been unmuted by the tutor') }}",
        }
    </script>

    <!-- Scripts -->
    <script src="{{ asset('assets/meeting/js/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/meeting/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/meeting/js/app.min.js') }}"></script>
    <script src="{{ asset('assets/meeting/js/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/meeting/js/main.js') }}"></script>
    @yield('script')
</body>

</html>
