@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">Generate Payment Orders</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('payment-orders.store') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
            @csrf
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('start_date') is-invalid @enderror">
                    <label class="control-label">Start Date <span style="color: red">*</span></label>
                    <input type="date" class="form-control" name="start_date" id="start_date" value="{{ old('start_date') }}" >
                    @error('start_date')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('end_date') is-invalid @enderror">
                    <label class="control-label">End Date <span style="color: red">*</span></label>
                    <input type="date" class="form-control" name="end_date" id="end_date" value="{{ old('end_date') }}" >
                    @error('end_date')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('tutors')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
@endsection