@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="nav-align-top">
            <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-2 gap-lg-0">
                <li class="nav-item">
                    <a class="nav-link  waves-effect waves-light" href="{{ route('profile') }}"><i class="ti-sm ti ti-users me-1_5"></i> Account</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active waves-effect waves-light" href="{{ route('profile.password') }}"><i class="ti-sm ti ti-lock me-1_5"></i> Security</a>
                </li>
            </ul>
        </div>
        <div class="card mb-6">
            <h5 class="card-header">Change Password</h5>
            <div class="card-body pt-1">
              <form action="{{ route('profile.password.submit') }}" name="passwordform" id="passwordform" method="POST" class="fv-plugins-bootstrap5 fv-plugins-framework" novalidate="novalidate">
                @csrf
                <div class="row">
                  <div class="mb-6 col-md-6 form-password-toggle fv-plugins-icon-container @error('current_password') is-invalid @enderror">
                    <label class="form-label" for="currentPassword">Current Password <span style="color: red">*</span></label>
                    <div class="input-group input-group-merge has-validation">
                      <input class="form-control" type="password" name="current_password" id="current_password"  placeholder="············">
                      <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                    </div>
                    @error('current_password')
                        <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                    </div>
                </div>
                <div class="row">
                  <div class="mb-6 col-md-6 form-password-toggle fv-plugins-icon-container  @error('password') is-invalid @enderror">
                    <label class="form-label" for="newPassword">New Password <span style="color: red">*</span></label>
                    <div class="input-group input-group-merge has-validation">
                      <input class="form-control" type="password" name="password" id="password" placeholder="············">
                      <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                    </div>
                    @error('password')
                        <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror              
                  </div>
        
                  <div class="mb-6 col-md-6 form-password-toggle fv-plugins-icon-container">
                    <label class="form-label" for="confirmPassword">Confirm New Password <span style="color: red">*</span></label>
                    <div class="input-group input-group-merge has-validation">
                      <input class="form-control" type="password" name="password_confirmation" id="password-confirm" placeholder="············">
                      <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                    </div>
                  </div>
                </div>
                <h6 class="text-body">Password Requirements:</h6>
                <ul class="ps-4 mb-0">
                  <li class="mb-4">Minimum 8 characters long - the more, the better</li>
                  <li class="mb-4">At least one lowercase character</li>
                  <li>At least one number, symbol, or whitespace character</li>
                </ul>
                <div class="mt-6">
                  <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Save changes</button>
                  <a href="{{ route('home')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
                </div>
              <input type="hidden"></form>
            </div>
        </div>
    </div>
</div>
@endsection