@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('page-style')
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
@endsection

@section('content')

<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">View Role</h5>
    </div>
    <div class="card-body pt-4">
        @if($role->name=='admin' || $role->name=='super-admin')
            @php
                $checkbox = '';
            @endphp
        @else
            @php
                $checkbox = '';
            @endphp    
        @endif
        <ul class="list-unstyled my-3 py-1">
            <li class="d-flex align-items-center mb-4">
              <i class="ti ti-user ti-lg"></i><span class="fw-medium mx-2">Name:</span>
              <span>{{ old( 'name', isset($role->name) ? $role->name : '') }}</span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <i class="ti ti-check ti-lg"></i><span class="fw-medium mx-2">Description:</span>
              <span>{{ old( 'description', isset($role->description) ? $role->description : '') }}</span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <i class="ti ti-crown ti-lg"></i><span class="fw-medium mx-2">Permissions:</span>
            </li>
        </ul>
        
        @if(isset($permissions) && $permissions->count()>0)
        <div class="col-12 fv-plugins-icon-container">
            <p class="mb-1">
                <div class="table-responsive mt-4">
                    <table class="table">
                    <thead>
                        <tr>
                        <th class="text-nowrap">Name</th>
                        <th class="text-nowrap">Permission</th>
                        <th class="text-nowrap text-center"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($permissions as $permission)
                        <tr>
                        <td class="text-nowrap text-heading">{{$permission->display_name}}</td>
                        <td class="text-nowrap text-heading">{{$permission->name}}</td>
                        <td>
                            <div class="form-check d-flex justify-content-center">
                                @if($checkbox!='')
                                    <input type="checkbox" name="permissions[]" id="{{$permission->name}}" value="{{$permission->name}}" {!! $checkbox !!}  checked>
                                @else
                                    <input type="checkbox" name="permissions[]" id="{{$permission->name}}" value="{{$permission->name}}" {!! $checkbox !!}  {{ ($role->hasPermissionTo($permission->name))?'checked':'' }}>
                                @endif
                            </div>
                        </td>
                        </tr>
                        @endforeach
                    </tbody>
                    </table>
                </div>        
            </p>
        </div>
    @endif
        
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
@endsection