@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('page-style')
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
@endsection

@section('content')

<div class="card mb-4">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">View Student</h5>
    </div>
    <div class="card-body pt-4">
        <ul class="list-unstyled my-3 py-1">
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">First Name:</span>
              <span>{{ old( 'first_name', isset($student->first_name) ? $student->first_name : '') }}</span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Last Name:</span>
              <span>{{ old( 'last_name', isset($student->last_name) ? $student->last_name : '') }}</span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Gender:</span>
              <span>{{ old( 'email', isset($student->gender) ? $student->gender : '') }}</span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Parent Name:</span>
              <span>{{ old( 'email', isset($student->parent_name) ? $student->parent_name : '') }}</span>
            </li>
            @can('create-student')
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Parent Email:</span>
              <span>{{ old( 'email', isset($student->parent_email) ? $student->parent_email : '') }}</span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Parent Mobile:</span>
              <span>{{ old( 'email', isset($student->parent_mobile) ? $student->parent_mobile : '') }}</span>
            </li>
            @endcan
        </ul>
    </div>
</div>

<br/>
<div class="card mb-6">
  <div class="card-header d-flex flex-wrap justify-content-between gap-4">
    <div class="card-title mb-0 me-1">
      <h5 class="mb-0">Batches ({{ $student->batches->count() }})</h5>
      
    </div> 
  </div>
  <div class="card-body">
    <div class="row gy-6 mb-6">
      @php
        $index = 1;
      @endphp
      @foreach ( $student->batches as $batch )
        <div class="col-sm-6 col-lg-4 ">
          <div class="card p-2 h-100 shadow-none border">
            <div class="rounded-2 text-center mb-4 ">
              <a href="{{ route('batches.view', $batch->id) }}"><img class="img-fluid" src="{{ asset('assets/img/pages/app-academy-tutor-'.rand(1, 6).'.png') }}" alt="batch image"></a>
            </div>
            <div class="card-body p-4 pt-2">
              <div class="d-flex justify-content-between align-items-center mb-4">
                <span class="badge bg-label-primary">{{ $batch->lessons->count()}} Lessons</span>
                <p class="d-flex align-items-center justify-content-center fw-medium gap-1 mb-0"></p>
              </div>
              <a href="javascript:void(0);" class="h5">{{ $batch->name }}</a>
            </div>
          </div>
        </div>

        @php
          $index++;
        @endphp
      @endforeach
    </div>
  </div>
</div>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
@endsection