@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">Add Ticket</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('tickets.store') }}" enctype="multipart/form-data" autocomplete="off" class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
            @csrf
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('name') is-invalid @enderror">
                    <label class="control-label">Ticket Number <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="number" id="number" value="{{ $ticket_number }}" maxlength="150" readonly>
                    @error('number')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('title') is-invalid @enderror">
                    <label class="control-label">Title <span style="color: red">*</span></label>
                        <input type="text" class="form-control" name="title" id="title" value="{{ old('title') }}" placeholder="Title" maxlength="150">
                    @error('title')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
                </div>
            <div class="col-12 fv-plugins-icon-container">
                <div class="form-group @error('description') is-invalid @enderror">
                    <label class="control-label">Description</label>
                    <textarea class="form-control" name="description" id="description" placeholder="Description Here" maxlength="150">{{ old( 'description') }}</textarea>
                    @error('description')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-4 fv-plugins-icon-container">
                <div class="form-group @error('priority') is-invalid @enderror">
                    <label class="control-label">Priority<span style="color: red">*</span></label>
                    <select class="form-control common-site" name="priority"  id="priority">
                        <option value="0">Low</option>
                        <option value="1">Medium</option>
                        <option value="2">High</option>
                    </select>
                    @error('priority')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-8 fv-plugins-icon-container">
                <div class="form-group @error('attachment') is-invalid @enderror">
                    <label class="control-label">Attachment<span
                            style="color: red">*</span></label>
                    <input type="file" class="form-control" name="attachment" id="attachment">
                    @error('attachment')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span> 
                    @enderror
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('tickets')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
<style>
  .accordion-body {
    height: 200px;
    overflow-x: hidden;
    overflow-y: auto;
  }
</style>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    $(document).ready(function() {
    });
</script>
@endsection