@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">Edit Ticket</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('tickets.store') }}" enctype="multipart/form-data" autocomplete="off" class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
            @csrf
            <input type="hidden" value="{{$ticket->id}}" name="id">
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('name') is-invalid @enderror">
                    <label class="control-label">Ticket Number <span style="color: red">*</span></label>
                    <p>{{ !empty($ticket->number) ? $ticket->number : '' }}</p>
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('title') is-invalid @enderror">
                    <label class="control-label">Title <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="title" id="title" value="{{ old('title', $ticket->title) }}" placeholder="Title" maxlength="150">
                    @error('title')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
                </div>
            <div class="col-12 fv-plugins-icon-container">
                <div class="form-group @error('description') is-invalid @enderror">
                    <label class="control-label">Description</label>
                    <textarea class="form-control" name="description" id="note">{{ old('description', $ticket->description) }}</textarea>
                    @error('description')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-4 fv-plugins-icon-container">
                <div class="form-group @error('priority') is-invalid @enderror">
                    <label class="control-label">Priority<span style="color: red">*</span></label>
                    <select class="form-control common-site" name="priority"  id="priority">
                      <option value="0" {{ $ticket->priority == 0 ? 'selected' : '' }}>Low</option>
                      <option value="1" {{ $ticket->priority == 1 ? 'selected' : '' }}>Medium</option>
                      <option value="2" {{ $ticket->priority == 2 ? 'selected' : '' }}>High</option>
                    </select>
                    @error('priority')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-8 fv-plugins-icon-container">
                <div class="form-group @error('attachment') is-invalid @enderror">
                    <label class="control-label">Attachment<span
                            style="color: red">*</span></label>
                    @if($ticket->attachment)
                    <a download="" href="{{ asset(config('constant.ticket_attach').$ticket->attachment) }}">{{ $ticket->attachment }}</a>
                    @endif
                    <input type="file" class="form-control" name="attachment" id="attachment">
                    @error('attachment')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('tickets')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    $(document).ready(function() {
    });
</script>
@endsection