@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card app-calendar-wrapper">
    <div class="row g-0">
      <!-- Calendar Sidebar -->
      <div class="col-4 app-calendar-sidebar border-end" id="app-calendar-sidebar">
        <div class="px-3 pt-2">
          <!-- inline calendar (flatpicker) -->
          <div class="inline-calendar"></div>
        </div>
        <hr class="mb-6" />
        <div class="px-6 pb-2">
          <!-- Filter -->
          <div>
            <h5>Lesson Filters</h5>
          </div>

          <div class="form-check form-check-secondary mb-5 ms-2">
            <input
              class="form-check-input select-all"
              type="checkbox"
              id="selectAll"
              data-value="all"
              checked />
            <label class="form-check-label" for="selectAll">View All</label>
          </div>
          <div class="app-calendar-events-filter text-heading">
            <div class="form-check form-check-info mb-5 ms-2">
              <input
                class="form-check-input input-filter"
                type="checkbox"
                id="select-planned"
                data-value="planned"
                checked />
              <label class="form-check-label" for="select-planned">Planned</label>
            </div>
            <div class="form-check form-check-warning mb-5 ms-2">
              <input
                class="form-check-input input-filter"
                type="checkbox"
                id="select-in_progress"
                data-value="in_progress"
                checked />
              <label class="form-check-label" for="select-in_progress">In Progress</label>
            </div>
            <div class="form-check form-check-success mb-5 ms-2">
              <input
                class="form-check-input input-filter"
                type="checkbox"
                id="select-completed"
                data-value="completed"
                checked />
              <label class="form-check-label" for="select-completed">Completed</label>
            </div>
            <div class="form-check form-check-danger mb-5 ms-2">
              <input
                class="form-check-input input-filter"
                type="checkbox"
                id="select-cancelled"
                data-value="cancelled"
                checked />
              <label class="form-check-label" for="select-cancelled">Cancelled</label>
            </div>
            <div class="form-check form-check-primary ms-2">
              <input
                class="form-check-input input-filter"
                type="checkbox"
                id="select-report_generated"
                data-value="report_generated"
                checked />
              <label class="form-check-label" for="select-report_generated">Report Generated</label>
            </div>
          </div>
        </div>
      </div>
      <!-- /Calendar Sidebar -->

      <!-- Calendar & Modal -->
      <div class="col-8 app-calendar-content">
        <div class="card shadow-none border-0">
          <div class="card-body pb-0">
            <!-- FullCalendar -->
            <div id="calendar"></div>
          </div>
        </div>
        <div class="app-overlay"></div>
        <!-- FullCalendar Offcanvas -->
        <div
          class="offcanvas offcanvas-end event-sidebar"
          tabindex="-1"
          id="addEventSidebar"
          aria-labelledby="addEventSidebarLabel">
          
        </div>
      </div>
      <!-- /Calendar & Modal -->
    </div>
  </div>
@endsection
@section('page-script')

<script src="{{ asset('assets/vendor/libs/fullcalendar/fullcalendar.js') }}"></script>
<script src="{{ asset('assets/vendor/libs/@form-validation/popular.js') }}"></script>
<script src="{{ asset('assets/vendor/libs/@form-validation/bootstrap5.js') }}"></script>
<script src="{{ asset('assets/vendor/libs/@form-validation/auto-focus.js') }}"></script>
<script src="{{ asset('assets/vendor/libs/moment/moment.js') }}"></script>
<script src="{{ asset('assets/vendor/libs/flatpickr/flatpickr.js') }}"></script>
<script src='https://unpkg.com/tooltip.js/dist/umd/tooltip.min.js'></script>

<!-- Page JS -->
<script src="{{ asset('assets/js/app-calendar-events.js') }}"></script>
<script src="{{ asset('assets/js/app-calendar.js') }}"></script>

@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    var events = JSON.parse({!! json_encode($lessons) !!});

    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });

      events.forEach(event => {
        event.start = new Date(event.start);
        event.end = new Date(event.end);
      });

      window.events = events;
    });
</script>
@endsection
@section('page-style')
<link rel="stylesheet" href="{{ asset('assets/vendor/libs/fullcalendar/fullcalendar.css') }}" />
<style>
  .fc-event-title{
    font-size: .7em !important;
  }
</style>
@endsection