<?php
    $page_title = 'Login';
?>
<?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php $__env->startSection('content'); ?>
<!-- /Left Text -->
<div class="d-none d-lg-flex col-lg-8 p-0">
  <div class="auth-cover-bg auth-cover-bg-color d-flex justify-content-center align-items-center">
    <img
      src="<?php echo e(asset('assets/img/illustrations/auth-login-illustration-light.png')); ?>"
      alt="auth-login-cover"
      class="my-5 auth-illustration" />

    <img
      src="<?php echo e(asset('assets/img/illustrations/bg-shape-image-light.png')); ?>"
      alt="auth-login-cover"
      class="platform-bg" />
  </div>
</div>
<!-- /Left Text -->
<!-- Login -->
<div class="d-flex col-12 col-lg-4 align-items-center authentication-bg p-sm-12 p-6">
  <div class="w-px-400 mx-auto mt-12 pt-5">
    <h4 class="mb-1">Welcome to <?php echo e(config('app.name')); ?>! 👋</h4>
    <p class="mb-6">Please sign-in to your account and start the adventure</p>

    <form id="formAuthentication" class="mb-6" action="<?php echo e(route('login')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="mb-6">
        <label for="email" class="form-label">Email or Username</label>
        <input
          type="text"
          class="form-control"
          id="email"
          name="email"
          placeholder="Enter your email or username"
          autofocus />
      </div>
      <div class="mb-6 form-password-toggle">
        <label class="form-label" for="password">Password</label>
        <div class="input-group input-group-merge">
          <input
            type="password"
            id="password"
            class="form-control"
            name="password"
            placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
            aria-describedby="password" />
          <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
        </div>
      </div>
      <div class="my-8">
        <div class="d-flex justify-content-between">
          <div class="form-check mb-0 ms-2">
            <input class="form-check-input" type="checkbox" id="remember-me" name="remember"/>
            <label class="form-check-label" for="remember-me"> Remember Me </label>
          </div>
          <a href="<?php echo e(route('password.request')); ?>">
            <p class="mb-0">Forgot Password?</p>
          </a>
        </div>
      </div>
      <button class="btn btn-primary d-grid w-100">Sign in</button>
    </form>

    <div class="divider my-6">
      <div class="divider-text">or</div>
    </div>

    <div class="d-flex justify-content-center">
      <a href="<?php echo e(route('socialite.auth', 'facebook')); ?>" class="btn btn-sm btn-icon rounded-pill btn-text-facebook me-1_5">
        <i class="tf-icons ti ti-brand-facebook-filled"></i>
      </a>

      <a href="<?php echo e(route('socialite.auth', 'google')); ?>" class="btn btn-sm btn-icon rounded-pill btn-text-google-plus">
        <i class="tf-icons ti ti-brand-google-filled"></i>
      </a>
    </div>
  </div>
</div>
<!-- /Login -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('page-script'); ?>
<?php if(Session::has('alert-message')): ?>
<script>
    Toast.fire({
        type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
        title: "<?php echo e(Session::get('alert-message')); ?>"
    });
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wvl75a7echxk/public_html/msme.codecods.com/resources/views/auth/login.blade.php ENDPATH**/ ?>