<?php if(isset($page_title) && $page_title!=''): ?>
    <?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('page-style'); ?>
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="card mb-4">
      <div class="card-header border-bottom">
        <h5 class="card-title mb-0">View Tutor</h5>
      </div>
      <div class="card-body pt-4">
          <ul class="list-unstyled my-3 py-1">
              <li class="d-flex align-items-center mb-4">
                <span class="fw-medium mx-2">First Name:</span>
                <span><?php echo e(old( 'first_name', isset($tutor->first_name) ? $tutor->first_name : '')); ?></span>
              </li>
              <li class="d-flex align-items-center mb-4">
                <span class="fw-medium mx-2">Last Name:</span>
                <span><?php echo e(old( 'last_name', isset($tutor->last_name) ? $tutor->last_name : '')); ?></span>
              </li>
              <li class="d-flex align-items-center mb-4">
                <span class="fw-medium mx-2">Email:</span>
                <span><?php echo e(old( 'email', isset($tutor->user->email) ? $tutor->user->email : '')); ?></span>
              </li>
              <li class="d-flex align-items-center mb-4">
                <span class="fw-medium mx-2">Status:</span>
                <?php
                      $status = '';
                      $type = '';
                      if($tutor->status == 0) {
                          $content = "PENDING";
                          $type = 'warning';
                      }
                      else if($tutor->status == 1) {
                          $content = "APPROVED";
                          $type = 'success';
                      }
                      else if($tutor->status == 2) {
                          $content = "REJECTED";
                          $type = 'danger';
                      }
                      else if($tutor->status == 3) {
                          $content = "DORMENT";
                          $type = 'danger';
                      }
                  ?>
                <span class='btn btn-label-<?php echo e($type); ?> <?php echo e($type); ?>-effect'><?php echo e($content); ?></span>
              </li>
          </ul>
      </div>
  </div>
  <div class="card">
    <div class="card-header">
      <h5 class="card-title mb-0">Batches (<?php echo e($tutor->batches->count()); ?>)</h5>
    </div>
    <div class="card-body">
      <div class="card-body table-responsive pt-4">
        <table id="DataTable1" class="datatables-roles table">
          <thead class="border-top">
            <tr>
              <th></th>
              <th>Name</th>
              <th>Tutor</th>
              <th>Lessons</th>
              <th>Created At</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/libs/datatables/jquery.dataTables.min.css')); ?>"></script>
<link rel="stylesheet" href="<?php echo e(asset('assets/libs/datatables/responsive.dataTables.min.css')); ?>"></script>
<link rel="stylesheet" href="<?php echo e(asset('assets/libs/datatables/jquery.dataTable.orderride.css')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/datatables/dataTables.bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/datatables/dataTables.responsive.min.js')); ?>"></script>
<script type="text/javascript">
    var table,
      batch_url = '<?php echo e(route("tutors.batches", $tutor->id )); ?>';
    $(document).ready(function() {
	    table=$('#DataTable1').DataTable({
	    	responsive: true,
	        processing: true,
	        serverSide: true,
	        searching: true,
	        ajax:{
	            headers: {'X-CSRF-Token': Laravel.csrfToken},
	            url:  batch_url,
	            type:'GET'
	        },
	        columns: [
	            {data: 'id', name: 'id'},
	            {data: 'name', name: 'name'},
	            {data: 'tutor_id', name: 'tutor_id'},
	            {data: 'lessons', name: 'lessons'},
	            {data: 'created_at', name: 'created_at'},
	            {data: 'action', name: 'action', sortable:false}
	        ],
	        order: [[0, 'desc']]
	    });
    });
    
    function deleteRecord(ele,id){
      Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes, delete it!',
          confirmButtonColor: "#d33",
          confirmButtonClass: 'btn btn-success',
          cancelButtonText: 'No, cancel!',
          cancelButtonColor: '#3085d6',
          cancelButtonClass: 'btn btn-danger',
          buttonsStyling: true,
          reverseButtons: true
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  type: "POST",
                  headers: {'X-CSRF-Token': Laravel.csrfToken},
                  url: batch_url,
                  dataType : 'json',
                  data: {id:id},
                  success: function(response) {
                      setTimeout( function () {
                          redrawDatatable();
                      }, 1000 );
                      if(response.success == true){
                        Swal.fire({
                            type : 'success',
                            title: 'Deleted!',
                            text : response.message,
                            timer: '1500'
                        });
                      }else{
                        Swal.fire({
                            type : 'error',
                            title: 'Not Deleted!',
                            text : response.message,
                            timer: '1500'
                        });
                      }
                  },
                  error: function (jqXHR, status, exception) {
                      if (jqXHR.status === 0) {
                          error = 'Not connected.\nPlease verify your network connection.';
                      } else if (jqXHR.status == 404) {
                          error = 'The requested page not found. [404]';
                      } else if (jqXHR.status == 500) {
                          error = 'Internal Server Error [500].';
                      } else if (exception === 'parsererror') {
                          error = 'Requested JSON parse failed.';
                      } else if (exception === 'timeout') {
                          error = 'Time out error.';
                      } else if (exception === 'abort') {
                          error = 'Ajax request aborted.';
                      } else {
                          error = 'Uncaught Error.\n' + jqXHR.responseText;
                      }
                      Swal.fire('Error!',error,'error');
                  }
              });
          }
      });
    }
    function redrawDatatable(){
        $('#DataTable1').DataTable().ajax.reload();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wvl75a7echxk/public_html/msme.codecods.com/resources/views/tutors/view.blade.php ENDPATH**/ ?>