<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Spatie\Permission\Models\Role; use App\Models\User; use App\Models\Batches; use App\Models\Students; use App\Models\Tutors; use App\Models\Lessons; use App\Models\Meeting; use App\Models\BatchFeeReminders; use App\Models\BatchStudents; use App\Models\StudentAttendances; use App\Mail\LessonReportGeneratedMail; use Carbon\Carbon; use DataTables; use Validator; use Session; use Auth; use Hash; use Mail; class LessonController extends Controller { public function __construct() { $this->middleware("\160\x65\x72\155\x69\x73\x73\x69\157\x6e\72\x76\x69\145\167\x2d\154\145\163\163\x6f\156", array("\157\156\x6c\x79" => array("\x69\x6e\144\145\x78", "\163\x68\x6f\x77"))); $this->middleware("\x70\145\162\155\x69\163\x73\151\157\156\x3a\143\x72\145\x61\x74\x65\55\154\x65\x73\x73\157\156", array("\157\x6e\154\171" => array("\x63\x72\x65\x61\164\x65", "\163\164\157\x72\x65"))); $this->middleware("\x70\145\x72\155\151\163\163\151\157\156\72\165\x70\144\141\164\x65\x2d\154\x65\x73\x73\157\x6e", array("\157\x6e\x6c\171" => array("\145\x64\151\164", "\x73\164\157\x72\145"))); $this->middleware("\x70\x65\x72\x6d\151\163\x73\x69\x6f\156\72\x64\x65\x6c\145\x74\x65\55\x6c\145\163\x73\157\156", array("\x6f\156\154\171" => array("\x64\x65\163\x74\x72\x6f\171"))); } public function reports(Request $request) { try { $data = array(); $data["\x70\141\x67\145\137\x74\151\x74\x6c\145"] = "\x4c\x65\163\x73\157\x6e\x20\x52\x65\x70\157\162\x74\x20\x4c\x69\163\x74"; if ($request->ajax()) { $user = Auth::user(); $lessons = null; if (Auth::user()->role_name == RoleTutor) { $tutor = Tutors::where("\165\163\x65\x72\x5f\x69\x64", $user->id)->first(); $lessons = Lessons::where("\x73\x74\x61\164\x75\163", LessonStatusReportGenerated)->whereHas("\142\x61\x74\x63\x68", function ($q) use($tutor) { $q->where("\164\165\164\x6f\162\x5f\x69\144", $tutor->id); })->whereNull("\x64\145\x6c\145\x74\145\144\137\141\164"); } else { $lessons = Lessons::where("\x73\164\x61\164\x75\163", LessonStatusReportGenerated)->whereNull("\x64\x65\154\x65\x74\x65\x64\x5f\x61\164"); } return DataTables::eloquent($lessons)->addColumn("\141\143\x74\151\x6f\156", function ($lessons) { $action = ''; if (Auth::user()->can("\x76\151\145\x77\55\x6c\145\x73\163\x6f\156")) { $action .= "\74\141\x20\x68\x72\145\x66\x3d\x22" . route("\154\145\163\163\x6f\x6e\x73\56\162\145\160\157\162\x74\163\56\166\x69\145\167", $lessons->id) . "\x22\x3e\x3c\x69\40\143\154\x61\x73\x73\x3d\x22\155\145\156\x75\x2d\x69\x63\x6f\x6e\x20\x74\x66\x2d\x69\143\157\156\x73\x20\164\x69\x20\x74\151\55\x65\x79\x65\42\76\74\x2f\x69\x3e\74\x2f\141\76\46\x6e\142\x73\x70\73"; } return $action; })->addColumn("\142\141\x74\x63\150\137\x6e\141\155\x65", function ($lessons) { return $lessons->batch->name; })->filterColumn("\x62\141\164\143\x68\x5f\156\141\155\145", function ($query, $keyword) { $query->whereHas("\142\x61\x74\143\x68", function ($q) use($keyword) { $q->where("\156\x61\155\x65", "\114\x49\x4b\x45", "{$keyword}\45"); }); })->addColumn("\164\x75\164\x6f\x72", function ($lessons) { return $lessons->batch->tutor->full_name; })->filterColumn("\x74\165\x74\x6f\x72", function ($query, $keyword) { $query->whereHas("\142\141\x74\143\x68", function ($q) use($keyword) { $query->whereHas("\x74\x75\164\x6f\162", function ($q1) use($keyword) { $q1->where("\x66\151\162\163\164\x5f\156\141\x6d\145", "\114\111\113\105", "{$keyword}\x25")->where("\154\x61\163\164\137\x6e\141\x6d\145", "\x4c\x49\x4b\x45", "{$keyword}\45"); }); }); })->editColumn("\x72\145\x70\x6f\162\164\137\147\x65\x6e\145\x72\x61\x74\x65\144\137\x61\x74", function ($lessons) { return $lessons->report_generated_at != null ? date(config("\x63\x6f\156\163\x74\141\x6e\164\x2e\x64\x61\164\x65\137\146\157\x72\155\x61\164"), strtotime($lessons->report_generated_at)) : "\x2d"; })->editColumn("\163\164\141\x72\x74\x5f\x64\x61\x74\x65", function ($lessons) { return $lessons->start_date != null ? date(config("\x63\157\x6e\163\x74\141\x6e\164\56\144\141\164\145\137\x66\157\162\x6d\x61\x74"), strtotime($lessons->start_date)) : "\55"; })->editColumn("\145\156\144\x5f\x64\x61\164\145", function ($lessons) { return $lessons->end_date != null ? date(config("\x63\x6f\156\x73\x74\x61\156\x74\x2e\144\141\164\145\137\146\157\162\155\141\164"), strtotime($lessons->end_date)) : "\55"; })->filterColumn("\163\164\141\x72\x74\137\144\x61\164\x65", function ($query, $keyword) { $query->whereRaw("\x44\101\124\x45\x5f\106\117\122\115\x41\124\50\163\x74\x61\x72\164\x5f\144\x61\164\145\54\47\45\x64\55\x25\x6d\x2d\x25\x59\x20\x25\150\72\45\x69\x20\45\x72\47\x29\40\x6c\151\153\145\40\77", array("\45{$keyword}\x25")); })->filterColumn("\x65\156\144\x5f\x64\x61\x74\145", function ($query, $keyword) { $query->whereRaw("\104\x41\124\105\137\106\x4f\x52\x4d\x41\x54\x28\x65\156\x64\137\x64\141\164\145\x2c\x27\45\x64\55\x25\155\55\x25\x59\x20\x25\x68\72\45\x69\40\45\x72\47\x29\40\154\x69\x6b\145\40\x3f", array("\45{$keyword}\x25")); })->rawColumns(array())->make(true); } return view("\x6c\x65\x73\163\157\x6e\163\x2e\x72\145\160\x6f\162\164\163", $data); } catch (\Exception $e) { return abort(404); } } public function viewReport($id) { try { $data["\x70\141\147\145\x5f\164\151\x74\154\x65"] = "\x56\151\x65\x77\x20\x52\145\160\x6f\162\x74"; $lesson = Lessons::where("\x69\x64", $id)->first(); if ($lesson) { $lesson_attendances = StudentAttendances::where("\154\145\163\x73\x6f\x6e\137\x69\144", $lesson->id)->orderBy("\x63\162\x65\x61\x74\x65\x64\x5f\142\171", "\x64\x65\163\x63")->take(5)->get(); $data["\154\x65\x73\x73\x6f\156"] = $lesson; $data["\x6c\x65\x73\x73\157\x6e\137\x61\x74\x74\x65\156\x64\141\156\143\145\163"] = $lesson_attendances; return view("\x6c\x65\x73\163\x6f\156\x73\x2e\x72\x65\x70\157\x72\x74", $data); } else { return abort(404); } } catch (\Exception $e) { return abort(404); } } public function show($id) { try { $data["\160\x61\x67\x65\137\164\151\164\x6c\145"] = "\x56\151\145\167\x20\x4c\x65\163\163\x6f\156"; $lesson = Lessons::where("\151\144", $id)->first(); $meeting = Meeting::where("\x6c\145\163\163\157\x6e\137\x69\x64", $lesson->id)->first(); if ($lesson) { if (Auth::user()->role_name == RoleStudent) { $student = Students::where("\x75\x73\x65\x72\137\x69\x64", Auth::user()->id)->first(); $data["\163\164\x75\x64\x65\156\164\137\x69\x64"] = $student->id; } $lesson_attendances = StudentAttendances::where("\x6c\145\163\x73\157\156\137\x69\x64", $lesson->id)->orderBy("\x63\x72\145\141\x74\145\x64\137\142\x79", "\144\x65\x73\143")->get(); $data["\x6c\x65\x73\163\x6f\156"] = $lesson; $data["\x6c\x65\x73\x73\x6f\x6e\137\141\164\164\x65\x6e\144\141\x6e\143\x65\163"] = $lesson_attendances; $data["\x63\141\156\137\163\x74\x61\x72\164\x5f\x6c\145\163\163\157\156"] = false; $data["\x6d\145\x65\x74\151\x6e\x67"] = $meeting; $batch = $lesson->batch; $tutor = Tutors::where("\151\x64", $batch->tutor_id)->first(); $lesson_recording_url = asset(config("\143\x6f\156\x73\x74\x61\x6e\x74\x2e\x72\145\x63\x6f\162\144\151\156\147\163") . $this->sanitize_string($tutor->full_name) . "\57" . $this->sanitize_string($batch->name)) . "\x2f" . $this->sanitize_string($lesson->name) . "\57"; $path = public_path(config("\x63\x6f\x6e\x73\x74\x61\x6e\x74\x2e\162\x65\x63\157\162\x64\x69\156\147\x73") . $this->sanitize_string($tutor->full_name) . "\x2f" . $this->sanitize_string($batch->name)) . "\57" . $this->sanitize_string($lesson->name); if (file_exists($path)) { $allFiles = scandir($path, SCANDIR_SORT_ASCENDING); $files = array_diff($allFiles, array("\x2e", "\x2e\x2e")); } else { $files = array(); } $data["\x72\x65\143\x6f\x72\144\151\x6e\x67\137\165\162\154"] = $lesson_recording_url; $data["\x66\151\154\x65\163"] = array_values($files); if ($lesson->status == LessonStatusPlanned && Carbon::now() >= Carbon::parse($lesson->start_date)) { $data["\143\x61\x6e\137\163\164\x61\162\x74\137\154\x65\163\x73\x6f\156"] = true; } return view("\x6c\145\x73\x73\157\x6e\163\56\166\151\x65\167", $data); } else { return abort(404); } } catch (\Exception $e) { dd($e); return abort(404); } } public function sanitize_string($string) { $special_chars = array("\x3f", "\x5b", "\135", "\x2f", "\134", "\x3d", "\x3c", "\76", "\x3a", "\73", "\54", "\47", "\42", "\46", "\x24", "\x23", "\x2a", "\x28", "\51", "\x7c", "\x7e", "\x60", "\41", "\173", "\x7d", "\x25", "\x2b", chr(0)); return preg_replace("\57\133\x5c\162\x5c\156\x5c\x74\40\x2d\135\x2b\x2f", "\137", $string); } public function status(Request $request) { $id = $request->id; try { if (isset($request->id) && !empty($request->id)) { $lesson = Lessons::where("\x69\x64", $id)->first(); $status = $request->status; if ($status == LessonStatusInProgress && Carbon::parse($lesson->start_date) > Carbon::now()) { Session::flash("\x61\154\145\162\164\x2d\155\x65\163\163\x61\x67\x65", "\x4c\145\x73\163\157\x6e\40\143\x61\x6e\x20\156\157\164\40\x62\x65\x20\163\164\x61\x72\x74\145\144\40\x62\x65\x66\157\x72\145\40\x73\143\150\145\x64\x75\154\145\x64\40\164\151\155\145\56"); Session::flash("\x61\154\x65\x72\164\55\143\154\x61\x73\163", "\145\x72\x72\157\x72"); return redirect()->route("\154\145\163\163\157\156\163\56\x76\151\x65\x77", $id); } else { $lesson->status = $request->status; $lesson->updated_by = Auth::user()->id; $lesson->updated_at = date("\x59\55\155\55\144\40\110\x3a\x69\72\x73"); if ($lesson->save()) { activity("\x4c\x65\x73\163\157\x6e")->performedOn($lesson)->causedBy(Auth::user())->log("\x73\164\x61\164\165\x73\x5f\x75\x70\x64\141\164\145\x64"); Session::flash("\141\154\145\162\x74\55\155\x65\163\163\141\x67\145", "\114\x65\x73\163\x6f\156\x20\x73\x74\x61\x74\x75\163\x20\x75\x70\144\x61\x74\145\x64\40\x73\x75\143\x63\145\163\163\x66\165\154\154\171\56"); Session::flash("\x61\x6c\145\x72\164\55\x63\154\141\x73\163", "\x73\x75\143\x63\145\163\x73"); return redirect()->route("\154\x65\163\x73\x6f\156\x73\56\166\151\x65\167", $id); } else { Session::flash("\x61\154\x65\x72\164\55\155\x65\x73\x73\x61\x67\x65", "\114\145\x73\163\x6f\156\x20\x73\x74\x61\x74\165\163\40\165\x70\144\141\x74\145\144\40\165\x6e\x73\165\143\143\145\163\x73\x66\x75\x6c\x6c\x79\56"); Session::flash("\x61\154\x65\x72\164\55\143\154\x61\x73\163", "\x65\x72\162\x6f\162"); return redirect()->route("\154\x65\163\x73\x6f\x6e\x73\x2e\x76\151\145\x77", $id); } } } } catch (\Exception $e) { Session::flash("\x61\154\x65\162\x74\x2d\x6d\x65\x73\163\x61\x67\145", $e->getMessage()); Session::flash("\141\x6c\x65\162\164\x2d\143\154\141\163\163", "\145\x72\162\157\162"); return redirect()->route("\154\x65\163\x73\157\x6e\x73\x2e\x76\151\145\x77", $id); } } public function generateReport(Request $request) { try { if (isset($request->lesson_id) && !empty($request->lesson_id)) { $id = $request->lesson_id; $lesson = Lessons::where("\151\x64", $id)->first(); $lesson->status = LessonStatusReportGenerated; $lesson->comments = $request->comments; $lesson->report_generated_at = date("\131\x2d\155\x2d\144\40\x48\x3a\151\72\163"); $lesson->updated_by = Auth::user()->id; $lesson->updated_at = date("\x59\x2d\x6d\55\144\40\x48\72\151\x3a\163"); if ($lesson->save()) { if (getSetting("\x41\x4c\114\x4f\127\x5f\115\101\x49\114\x5f\106\x45\101\x54\x55\x52\x45") == 1) { Mail::to(trim($lesson->batch->tutor->user->email))->send(new LessonReportGeneratedMail($lesson)); } activity("\114\145\163\x73\x6f\x6e")->performedOn($lesson)->causedBy(Auth::user())->log("\x72\x65\x70\157\x72\x74\x20\x67\145\156\x65\162\x61\x74\x65\144"); Session::flash("\x61\x6c\145\162\x74\55\155\x65\x73\163\141\147\x65", "\114\145\163\163\x6f\x6e\x20\162\145\160\157\x72\164\x20\x67\145\x6e\145\x72\141\x74\x65\x64\x20\163\x75\x63\143\x65\x73\x73\x66\165\x6c\154\171\x2e"); Session::flash("\x61\x6c\145\x72\x74\x2d\x63\154\x61\163\163", "\x73\165\x63\143\145\163\163"); return redirect()->route("\154\145\163\x73\157\156\163\x2e\166\x69\x65\x77", $id); } else { Session::flash("\141\x6c\x65\x72\164\55\x6d\x65\x73\x73\141\x67\x65", "\114\x65\x73\163\157\156\40\162\145\x70\157\162\164\40\x67\x65\156\145\x72\141\x74\x65\144\x20\165\156\163\x75\x63\x63\145\163\163\x66\x75\154\154\171\56"); Session::flash("\141\x6c\145\x72\164\55\143\x6c\141\163\x73", "\145\x72\162\x6f\162"); return redirect()->route("\154\x65\x73\163\157\x6e\163\x2e\166\151\145\167", $id); } } } catch (\Exception $e) { Session::flash("\x61\154\145\x72\x74\55\155\x65\x73\163\141\147\x65", $e->getMessage()); Session::flash("\141\154\x65\162\x74\55\x63\x6c\141\163\163", "\145\162\x72\x6f\x72"); return redirect()->route("\x6c\145\163\163\157\x6e\163\56\166\x69\x65\167", $id); } } public function attendance(Request $request) { $lesson_id = $request->lesson_id; try { if (isset($lesson_id) && !empty($lesson_id)) { $lesson = Lessons::where("\151\144", $lesson_id)->first(); $student_id = $request->student_id; $attendance = StudentAttendances::where(array("\x6c\x65\163\x73\x6f\x6e\x5f\x69\x64" => $lesson_id, "\163\164\165\144\x65\156\x74\x5f\151\x64" => $student_id))->first(); if ($attendance) { $attendance->status = $request->status; $attendance->updated_by = Auth::user()->id; $attendance->updated_at = date("\x59\55\155\55\x64\x20\110\72\x69\72\163"); if ($attendance->save()) { activity("\x53\164\165\144\145\x6e\x74\101\x74\x74\x65\x6e\x64\x61\x6e\x63\145")->performedOn($attendance)->causedBy(Auth::user())->log("\x75\x70\144\x61\x74\x65\144"); Session::flash("\141\154\145\162\x74\x2d\155\x65\x73\x73\141\x67\145", "\123\164\x75\x64\x65\156\164\x20\x41\x74\x74\x65\x6e\x64\x61\x6e\143\x65\x20\165\x70\144\x61\164\145\x64\x20\163\x75\x63\x63\145\163\163\x66\165\154\x6c\171\56"); Session::flash("\x61\154\x65\x72\164\x2d\x63\154\141\x73\163", "\163\x75\x63\143\145\163\163"); return redirect()->route("\154\145\163\x73\x6f\x6e\x73\56\166\x69\x65\167", $lesson_id); } else { Session::flash("\x61\154\145\162\x74\x2d\x6d\x65\x73\163\x61\x67\145", "\x53\164\x75\144\145\156\164\40\101\164\164\x65\156\x64\141\156\x63\x65\x20\163\164\141\164\165\x73\x20\165\x70\144\x61\164\145\144\40\x75\x6e\163\165\x63\x63\x65\x73\x73\x66\165\154\x6c\x79\56"); Session::flash("\141\154\145\x72\164\x2d\x63\154\141\x73\x73", "\145\x72\162\x6f\162"); return redirect()->route("\154\145\x73\163\157\156\x73\x2e\x76\151\145\x77", $lesson_id); } } else { $attendance = new StudentAttendances(); $attendance->lesson_id = $request->lesson_id; $attendance->student_id = $request->student_id; $attendance->status = $request->status; $attendance->created_by = Auth::user()->id; $attendance->created_at = date("\x59\55\155\x2d\x64\40\110\72\151\x3a\163"); if ($attendance->save()) { activity("\x53\x74\165\144\x65\156\x74\101\164\164\145\156\x64\x61\x6e\143\x65")->performedOn($attendance)->causedBy(Auth::user())->log("\143\x72\x65\141\x74\145\x64"); Session::flash("\141\154\x65\x72\x74\x2d\x6d\x65\x73\163\x61\147\x65", "\x53\164\165\144\x65\x6e\x74\x20\101\x74\164\145\x6e\144\x61\156\143\x65\40\143\x72\145\x61\x74\x65\x64\40\x73\165\x63\x63\x65\163\x73\x66\165\154\x6c\x79\x2e"); Session::flash("\x61\x6c\x65\162\164\55\x63\x6c\141\x73\x73", "\x73\165\143\x63\145\x73\163"); return redirect()->route("\154\145\x73\x73\157\x6e\x73\x2e\x76\151\145\167", $lesson_id); } else { Session::flash("\141\154\145\x72\164\x2d\x6d\145\x73\x73\x61\147\x65", "\x53\x74\165\144\145\x6e\164\x20\101\164\x74\x65\x6e\144\x61\x6e\143\145\40\x63\x72\145\141\x74\145\x64\x20\165\x6e\163\165\x63\143\x65\x73\x73\146\x75\154\x6c\x79\x2e"); Session::flash("\141\x6c\145\x72\x74\55\x63\154\x61\x73\163", "\x65\162\162\157\162"); return redirect()->route("\x6c\145\x73\x73\157\x6e\x73\x2e\x76\x69\145\167", $lesson_id); } } } } catch (\Exception $e) { Session::flash("\141\x6c\x65\162\164\55\155\x65\163\163\x61\x67\145", $e->getMessage()); Session::flash("\x61\x6c\145\162\x74\55\x63\x6c\141\x73\x73", "\x65\162\162\157\162"); return redirect()->route("\154\x65\x73\x73\x6f\x6e\163\x2e\166\151\x65\167", $lesson_id); } } public function destroy(Request $request) { if ($request->ajax()) { try { $lesson = Lessons::where("\x69\x64", $request->id)->first(); if ($lesson) { $lesson->attendances()->delete(); $lesson->meeting()->delete(); $lesson->disableLogging(); $lesson->deleted_by = Auth::user()->id; $lesson->save(); $lesson->enableLogging(); if ($lesson->delete()) { $response["\163\x75\x63\x63\x65\163\x73"] = true; $response["\x6d\145\163\x73\141\147\145"] = "\114\145\x73\x73\x6f\156\x20\144\x65\x6c\x65\164\145\144\40\163\x75\x63\143\145\163\x73\x66\x75\x6c\154\171\56"; } else { $response["\x73\x75\x63\143\145\163\x73"] = false; $response["\155\145\x73\x73\141\147\x65"] = "\x4c\x65\x73\163\x6f\x6e\x20\144\145\x6c\145\x74\145\x64\x20\x75\156\163\165\x63\143\x65\x73\x73\146\165\154\x6c\x79\x2e"; } } else { $response["\163\x75\x63\x63\x65\163\163"] = false; $response["\155\x65\x73\163\x61\x67\x65"] = "\x4c\145\x73\163\157\x6e\x20\x72\x65\143\157\x72\144\x20\156\x6f\x74\40\146\157\165\x6e\x64\56"; } } catch (\Exception $e) { $response["\x73\165\143\143\x65\163\x73"] = false; $response["\x6d\145\x73\x73\x61\147\x65"] = $e->getMessage(); } return response()->json($response); } else { return abort(404); } } }