<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BatchCreatedParentMail extends Mailable
{
    use Queueable, SerializesModels;

    public $batch, $student;

    /**
     * Create a new message instance.
     */
    public function __construct($batch, $student)
    {
        $this->batch = $batch;
        $this->student = $student;
    }

    /**
     * Get the message envelope.
     */
    public function build()
    {
        return $this->subject("Batch created | ".config('app.name'))->markdown('mails.batch_created_parent')
            ->with([
            'batch' => $this->batch,
            'student' => $this->student
        ]);
    }
}
