<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class LessonReportGeneratedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $lesson;

    /**
     * Create a new message instance.
     */
    public function __construct($lesson)
    {
        $this->lesson = $lesson;
    }

    /**
     * Get the message envelope.
     */
    public function build()
    {
        return $this->subject("Lesson Report generated | ".config('app.name'))->markdown('mails.lesson_report_generated')
            ->with([
            'lesson' => $this->lesson
        ]);
    }
}
