<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\PaymentOrders;
use PDF;


class PaymentOrderInvoiceMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user, $purchaseOrder;

    /**
     * Create a new message instance.
     */
    public function __construct($user)
    {
        $this->user = $user;
        // $this->purchaseOrder = $purchaseOrder;
    }

    /**
     * Get the message envelope.
     */
    public function build()
    {
        $paymentOrder = PaymentOrders::where('id', $this->user)->with(['lessons', 'lessons.lesson', 'lessons.lesson.batch'])->first();
        $data = [];
        $pdf = PDF::loadView('payment_orders.pdf', compact('paymentOrder', 'data'))->setPaper('a4', 'landscape');
        return $this->subject('Your Salary Breakdown for This Month')
            ->view('mails.welcome')->attachData($pdf->output(), 'payment_details.pdf', [
                    'mime' => 'application/pdf',
                ]);
    }
}
