<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class StudentOnBoardTutorMail extends Mailable
{
    use Queueable, SerializesModels;

    public $batch, $student;

    /**
     * Create a new message instance.
     */
    public function __construct($student, $batch)
    {
        $this->student = $student;
        $this->batch = $batch;
    }

    /**
     * Get the message envelope.
     */
    public function build()
    {
        return $this->subject("Student entrolled for your batch | ".config('app.name'))->markdown('mails.student_on_board_tutor')
            ->with([
            'batch' => $this->batch,
            'student' => $this->student
        ]);
    }
}
