<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class UserPasswordChangeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user, $new_password;

    /**
     * Create a new message instance.
     */
    public function __construct($user, $new_password)
    {
        $this->user = $user;
        $this->new_password = $new_password;
    }

    /**
     * Get the message envelope.
     */
    public function build()
    {
        return $this->subject("Your credentials has been updated on ".config('app.name'))->markdown('mails.user_change_password')
            ->with([
            'user' => $this->user,
            'new_password' => $new_password
        ]);
    }
}
