<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Lessons extends Model{

    use SoftDeletes;
    use LogsActivity;
    
    protected static $logAttributes = '*';
    protected static $logFillable   = true;
    protected static $logOnlyDirty  = true;
    protected static $logName       = 'Lessons';
    protected $primaryKey           = "id";

    protected $table                = 'lessons';
    protected $fillable             = [
        'name', 'start_date', 'end_date', 'charge', 'status', 'batch_id', 'is_report_required',
        'created_at','created_by', 'updated_at','updated_by','deleted_by','deleted_at'
    ];

    public $timestamps              = false;
    protected $dates                = ['deleted_at'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }

    public function batch(){
        return $this->belongsTo(Batches::class,'batch_id','id');
    }
    public function attendances(){
        return $this->hasMany(StudentAttendances::class,'lesson_id','id');
    }
    public function meeting(){
        return $this->hasOne(Meeting::class, 'id', 'lesson_id');
    }
    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function _updated_by(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
}
