<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Meeting extends Model
{
    use HasFactory;

    protected $table                = 'meetings';
    protected $primaryKey           = "id";
    protected $fillable             = [
        'meeting_id', 'lesson_id', 'title', 'description', 'invites', 
        'user_id', 'password', 'status', 
        'date', 'time', 'timezone', 'created_at','updated_at'
    ];

    public function user(){
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function lesson(){
        return $this->belongsTo(Lessons::class,'lesson_id','id');
    }

    public function participants(){
        return $this->hasMany(MeetingParticipants::class,'meeting_id','id');
    }

    public function scopeActiveParticipant($query, $meeting_id, $user_id)
    {
        return $query->where('id', $meeting_id)->whereHas('participants', function ($q) use ($user_id) {
            return $q->where('user_id', $user_id);
        })->count() > 0 ;
    }
}
