<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MeetingParticipants extends Model
{
    use HasFactory;

    protected $table                = 'meeting_participants';
    protected $primaryKey           = "id";
    protected $fillable             = [
        'meeting_id', 'joined_at', 'leave_at', 'user_id'
    ];

    public function user(){
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function meeting(){
        return $this->belongsTo(Lessons::class,'meeting_id','id');
    }
}
