<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class PaymentOrderLessons extends Model{

    use SoftDeletes;
    use LogsActivity;
    
    protected static $logAttributes = '*';
    protected static $logFillable   = true;
    protected static $logOnlyDirty  = true;
    protected static $logName       = 'PaymentOrderLessons';
    protected $primaryKey           = "id";

    protected $table                = 'payment_order_lessons';
    protected $fillable             = [
        'order_id', 'lesson_id'
    ];

    public $timestamps              = false;
    protected $dates                = ['deleted_at'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }

    public function payment_order(){
        return $this->belongsTo(PaymentOrders::class,'order_id','id');
    }

    public function lesson(){
        return $this->belongsTo(Lessons::class,'lesson_id','id');
    }
    
    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }

    public function _updated_by(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
}
