<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class PaymentOrders extends Model{

    use SoftDeletes;
    use LogsActivity;
    
    protected static $logAttributes = '*';
    protected static $logFillable   = true;
    protected static $logOnlyDirty  = true;
    protected static $logName       = 'PaymentOrders';
    protected $primaryKey           = "id";

    protected $table                = 'payment_orders';
    protected $fillable             = [
        'number', 'tutor_id', 'status', 'start_date', 'end_date',
        'created_at','created_by', 'updated_at','updated_by','paid_at','user_id'
    ];

    public $timestamps              = false;
    protected $dates                = ['deleted_at'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }
    public function tutor(){
        return $this->belongsTo(Tutors::class,'tutor_id','id');
    }
    public function lessons(){
        return $this->hasMany(PaymentOrderLessons::class,'order_id','id');
    }
    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function _updated_by(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
}
