<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Roles extends Model{

    use SoftDeletes;
    use LogsActivity;
    
    protected static $logAttributes = '*';
    protected static $logFillable   = true;
    protected static $logOnlyDirty  = true;
    protected static $logName       = 'Role';
    protected $primaryKey           = "id";

    protected $table                = 'roles';
    protected $fillable             = [
        'name','display_name','description','guard_name','created_at','created_by','updated_at','updated_by','deleted_by','deleted_at'
    ];
    public $timestamps              = false;
    protected $dates                = ['deleted_at'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }

    public function users(){
        return $this->hasMany(User::class,'role_id','id');
    }

    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function _updated_by(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
}
