<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Students extends Model{

    use SoftDeletes;
    use LogsActivity;
    
    protected static $logAttributes = '*';
    protected static $logFillable   = true;
    protected static $logOnlyDirty  = true;
    protected static $logName       = 'Students';
    protected $primaryKey           = "id";

    protected $table                = 'students';
    protected $fillable             = [
        'gender', 'first_name', 'last_name', 'parent_name', 'parent_email', 'parent_mobile', 'created_at','created_by',
        'updated_at','updated_by','deleted_by','deleted_at'
    ];

    public $timestamps              = false;
    protected $dates                = ['deleted_at'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }
    
    public function getFullNameAttribute()
    {
       return ucfirst($this->first_name) . ' ' . ucfirst($this->last_name);
    }
    
    public function getAvatarSymbolAttribute()
    {
       return mb_substr(ucfirst($this->first_name), 0, 1);
    }
    
    public function user(){
        return $this->belongsTo(User::class,'user_id','id');
    }
    
    public function batches(){
        return $this->belongsToMany(Batches::class, 'batch_students');
    }
    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function _updated_by(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
}
