<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Tickets extends Model{

    use SoftDeletes;
    use LogsActivity;
    
    protected static $logAttributes = '*';
    protected static $logFillable   = true;
    protected static $logOnlyDirty  = true;
    protected static $logName       = 'Ticket';
    protected $primaryKey           = "id";

    protected $table                = 'tickets';
    protected $fillable             = [
        'number', 'title', 'description', 'priority', 'status', 'attachment', 'is_read', 
        'tutor_id', 'assigned_to', 'assigned_by', 'assigned_at', 'created_at', 'created_by', 'updated_at', 'updated_by'
    ];

    public $timestamps              = false;
    protected $dates                = ['deleted_at'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }
    public function tutor(){
        return $this->hasOne(Tutors::class,'id','site_id');
    }
    public function comments(){
        return $this->hasMany(TicketTimelines::class,'ticket_id','id');
    }
    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function _updated_by(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
    public function _assigned_to(){
        return $this->belongsTo(User::class,'assigned_to','id');
    }
    public function _assigned_by(){
        return $this->belongsTo(User::class,'assigned_by','id');
    }
}
