<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasRoles, HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'facebook_id', 
        'google_id', 
    ];
    
    protected $with = [
        'roles', 
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    protected $appends = [ 'role_name' ];

    
    public function getRoleNameAttribute()
    {
       return $this->getRoleNames()->get(0);
    }

    public function tutor(){
        return $this->hasOne(Tutors::class,'id','user_id');
    }
    
    public function _created_by(){
        return $this->belongsTo(User::class,'created_by','id');
    }
    public function _updated_by(){
        return $this->belongsTo(User::class,'updated_by','id');
    }
}
